/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.aufdemrand.denizen.CommandHandler;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.listeners.ListenerRegistry;
import net.aufdemrand.denizen.npc.activities.ActivityEngine;
import net.aufdemrand.denizen.npc.activities.ActivityRegistry;
import net.aufdemrand.denizen.npc.dNPCRegistry;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.npc.traits.ConstantsTrait;
import net.aufdemrand.denizen.npc.traits.FishingTrait;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.npc.traits.NameplateTrait;
import net.aufdemrand.denizen.npc.traits.NicknameTrait;
import net.aufdemrand.denizen.npc.traits.PushableTrait;
import net.aufdemrand.denizen.npc.traits.SittingTrait;
import net.aufdemrand.denizen.npc.traits.SleepingTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.CommandRegistry;
import net.aufdemrand.denizen.scripts.containers.core.WorldScriptHelper;
import net.aufdemrand.denizen.scripts.requirements.RequirementRegistry;
import net.aufdemrand.denizen.scripts.triggers.TriggerRegistry;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.RuntimeCompiler;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Denizen
extends JavaPlugin {
    public static String versionTag = "0.8.8 pre-release";
    private boolean startedSuccessful = false;
    private CommandHandler commandHandler;
    private ScriptEngine scriptEngine = new ScriptEngine(this);
    private ActivityEngine activityEngine = new ActivityEngine(this);
    private CommandRegistry commandRegistry = new CommandRegistry(this);
    private TriggerRegistry triggerRegistry = new TriggerRegistry(this);
    private RequirementRegistry requirementRegistry = new RequirementRegistry(this);
    private ActivityRegistry activityRegistry = new ActivityRegistry(this);
    private ListenerRegistry listenerRegistry = new ListenerRegistry(this);
    private dNPCRegistry dNPCRegistry;
    private FlagManager flagManager = new FlagManager(this);
    private TagManager tagManager = new TagManager(this);
    public Depends depends = new Depends();
    private FileConfiguration savesConfig = null;
    private File savesConfigFile = null;

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public ActivityEngine getActivityEngine() {
        return this.activityEngine;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public ActivityRegistry getActivityRegistry() {
        return this.activityRegistry;
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public dNPCRegistry getNPCRegistry() {
        return this.dNPCRegistry;
    }

    public ListenerRegistry getListenerRegistry() {
        return this.listenerRegistry;
    }

    public RequirementRegistry getRequirementRegistry() {
        return this.requirementRegistry;
    }

    public TriggerRegistry getTriggerRegistry() {
        return this.triggerRegistry;
    }

    public FlagManager flagManager() {
        return this.flagManager;
    }

    public TagManager tagManager() {
        return this.tagManager;
    }

    public void onEnable() {
        this.depends.initialize();
        if (Depends.citizens == null || !Depends.citizens.isEnabled()) {
            dB.echoError("Citizens does not seem to be activated! Deactivating Denizen!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.startedSuccessful = true;
        dB.echoDebug(dB.DebugElement.Footer);
        dB.echoDebug(ChatColor.YELLOW + " _/_ _  ._  _ _  ");
        dB.echoDebug(ChatColor.YELLOW + "(/(-/ )/ /_(-/ ) " + ChatColor.GRAY + " scriptable NPCs");
        dB.echoDebug(dB.DebugElement.Spacer);
        dB.echoDebug(ChatColor.GRAY + "by: " + ChatColor.WHITE + "aufdemrand");
        dB.echoDebug(ChatColor.GRAY + "version: " + ChatColor.WHITE + versionTag);
        dB.echoDebug(dB.DebugElement.Footer);
        this.dNPCRegistry = new dNPCRegistry(this);
        this.commandHandler = new CommandHandler(Depends.citizens);
        ScriptRegistry._registerCoreTypes();
        this.saveDefaultConfig();
        this.reloadConfig();
        ScriptHelper.reloadScripts();
        this.reloadSaves();
        WorldScriptHelper ws_helper = new WorldScriptHelper();
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(TriggerTrait.class).withName("triggers"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(PushableTrait.class).withName("pushable"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(AssignmentTrait.class).withName("assignment"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(NicknameTrait.class).withName("nickname"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(HealthTrait.class).withName("health"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ConstantsTrait.class).withName("constants"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(NameplateTrait.class).withName("nameplate"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(SittingTrait.class).withName("sitting"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(FishingTrait.class).withName("fishing"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(SleepingTrait.class).withName("sleeping"));
        if (Depends.protocolManager != null) {
            new PacketHelper(this);
            dB.echoApproval("ProtocolLib hooked, traits and commands with custom packages can be used!");
        }
        RuntimeCompiler compiler = new RuntimeCompiler(this);
        compiler.loader();
        this.getCommandRegistry().registerCoreMembers();
        this.getTriggerRegistry().registerCoreMembers();
        this.getActivityRegistry().registerCoreMembers();
        this.getRequirementRegistry().registerCoreMembers();
        this.getListenerRegistry().registerCoreMembers();
        this.tagManager().registerCoreTags();
        Depends.citizens.registerCommandClass(CommandHandler.class);
        dB.echoDebug(dB.DebugElement.Footer);
        ws_helper.serverStartEvent();
    }

    public void onDisable() {
        if (!this.startedSuccessful) {
            return;
        }
        Location._saveLocations();
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.getListenerRegistry().deconstructPlayer((OfflinePlayer)player);
        }
        for (Player player : this.getServer().getOfflinePlayers()) {
            this.getListenerRegistry().deconstructPlayer((OfflinePlayer)player);
        }
        this.getCommandRegistry().disableCoreMembers();
        this.getLogger().log(Level.INFO, " v" + this.getDescription().getVersion() + " disabled.");
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        this.saveSaves();
    }

    public void reloadSaves() {
        if (this.savesConfigFile == null) {
            this.savesConfigFile = new File(this.getDataFolder(), "saves.yml");
        }
        this.savesConfig = YamlConfiguration.loadConfiguration((File)this.savesConfigFile);
        Location._recallLocations();
    }

    public FileConfiguration getSaves() {
        if (this.savesConfig == null) {
            this.reloadSaves();
        }
        return this.savesConfig;
    }

    public void saveSaves() {
        if (this.savesConfig == null || this.savesConfigFile == null) {
            return;
        }
        try {
            Location._saveLocations();
            this.savesConfig.save(this.savesConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.savesConfigFile, ex);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        Citizens citizens = (Citizens)this.getServer().getPluginManager().getPlugin("Citizens");
        return citizens.onCommand(sender, cmd, cmdName, args);
    }
}

