/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.ArrayList;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.server.v1_4_R1.EntityFishingHook;
import net.minecraft.server.v1_4_R1.EntityHuman;
import net.minecraft.server.v1_4_R1.World;
import net.minecraft.server.v1_4_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_4_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class FishingTrait
extends Trait {
    @Persist(value="fishing")
    private boolean fishing = false;
    @Persist(value="fishing hole")
    private Location fishingLocation = null;
    ArrayList<Location> available = new ArrayList();
    EntityHuman eh = null;
    WorldServer nmsworld = null;
    Location fishingSpot = null;
    EntityFishingHook fishHook = null;
    Entity fish = null;
    int reelCount = 100;
    int castCount = 0;

    public void run() {
        ++this.reelCount;
        ++this.castCount;
        if (this.reelCount == 500) {
            this.reel();
            this.reelCount = 0;
            this.castCount = 425;
        }
        if (this.castCount == 500) {
            try {
                this.fish.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cast();
            this.castCount = 0;
        }
    }

    public void onSpawn() {
        this.eh = ((CraftPlayer)this.npc.getBukkitEntity()).getHandle();
        this.nmsworld = ((CraftWorld)this.npc.getBukkitEntity().getWorld()).getHandle();
        this.fishHook = new EntityFishingHook((World)this.nmsworld, this.eh);
    }

    public void startFishing() {
        this.fishing = true;
        this.fishingLocation = this.npc.getBukkitEntity().getLocation();
    }

    private void findAvailable() {
        this.available.clear();
        Location loc = this.fishingLocation.clone();
        Location xLeft = loc.add(-1.0, 0.0, 0.0);
        loc = this.fishingLocation.clone();
        Location xRight = loc.add(1.0, 0.0, 0.0);
        loc = this.fishingLocation.clone();
        Location zBack = loc.add(0.0, 0.0, -1.0);
        loc = this.fishingLocation.clone();
        Location zForward = loc.add(0.0, 0.0, 1.0);
        this.available.add(this.fishingLocation);
        if (xLeft.getBlock().getTypeId() == 9 || xLeft.getBlock().getTypeId() == 8) {
            this.available.add(xLeft);
        }
        if (xRight.getBlock().getTypeId() == 9 || xRight.getBlock().getTypeId() == 8) {
            this.available.add(xRight);
        }
        if (zBack.getBlock().getTypeId() == 9 || zBack.getBlock().getTypeId() == 8) {
            this.available.add(zBack);
        }
        if (zForward.getBlock().getTypeId() == 9 || zForward.getBlock().getTypeId() == 8) {
            this.available.add(zForward);
        }
    }

    private void cast() {
        DenizenAPI.getDenizenNPC(this.npc).action("cast fishing rod", null);
        this.findAvailable();
        this.fishHook = new EntityFishingHook((World)this.nmsworld, this.eh);
        this.nmsworld.addEntity((net.minecraft.server.v1_4_R1.Entity)this.fishHook);
        int x = (int)(Math.random() * (double)this.available.size());
        this.fishingSpot = this.available.get(x);
        Vector v1 = this.fishHook.getBukkitEntity().getLocation().toVector();
        Vector v2 = this.fishingSpot.toVector();
        Vector v3 = v2.subtract(v1).normalize().multiply(1.5);
        ((Projectile)this.fishHook.getBukkitEntity()).setShooter(this.npc.getBukkitEntity());
        PlayerAnimation.ARM_SWING.play((Player)this.npc.getBukkitEntity());
        this.fishHook.getBukkitEntity().setVelocity(v3);
    }

    private void reel() {
        DenizenAPI.getDenizenNPC(this.npc).action("reel in fishing rod", null);
        int chance = (int)(Math.random() * 100.0);
        if (chance > 65) {
            Item fish = this.fishingSpot.getWorld().dropItem(this.fishingSpot, new ItemStack(Material.RAW_FISH));
            Vector v1 = fish.getLocation().toVector();
            Vector v2 = this.npc.getBukkitEntity().getLocation().add(0.0, 14.0, 0.0).toVector();
            Vector v3 = v2.subtract(v1).normalize().multiply(0.975);
            fish.setVelocity(v3);
        }
        PlayerAnimation.ARM_SWING.play((Player)this.npc.getBukkitEntity());
        this.fishHook.getBukkitEntity().remove();
    }

    public void startFishing(Location location) {
        DenizenAPI.getDenizenNPC(this.npc).action("start fishing", null);
        this.nmsworld.addEntity((net.minecraft.server.v1_4_R1.Entity)this.fishHook);
        Vector v1 = this.fishHook.getBukkitEntity().getLocation().toVector();
        Vector v2 = location.toVector();
        Vector v3 = v2.subtract(v1).normalize().multiply(1.5);
        ((Projectile)this.fishHook.getBukkitEntity()).setShooter(this.npc.getBukkitEntity());
        PlayerAnimation.ARM_SWING.play((Player)this.npc.getBukkitEntity());
        this.fishHook.getBukkitEntity().setVelocity(v3);
        this.fishing = true;
        this.fishingLocation = location;
        this.fishingSpot = this.fishingLocation.clone();
        this.findAvailable();
    }

    public void stopFishing() {
        DenizenAPI.getDenizenNPC(this.npc).action("stop fishing", null);
        PlayerAnimation.ARM_SWING.play((Player)this.npc.getBukkitEntity());
        dB.log("...removing fish hook.");
        this.fishHook.getBukkitEntity().remove();
        this.fishingLocation = null;
        this.fishingSpot = null;
        this.fishing = false;
    }

    public boolean isFishing() {
        return this.fishing;
    }

    public Location getFishingLocation() {
        return this.fishingLocation;
    }

    public FishingTrait() {
        super("fishing");
    }
}

