/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.interfaces.ExternalDenizenClass;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;
import org.shade.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler;
import org.shade.abstractmeta.toolbox.compilation.compiler.impl.JavaSourceCompilerImpl;

public class RuntimeCompiler {
    Denizen denizen;

    public RuntimeCompiler(Denizen denizen) {
        this.denizen = denizen;
    }

    public void loader() {
        String fileName;
        File[] files;
        File file;
        ArrayList<String> dependencies = new ArrayList<String>();
        dB.echoDebug("Loading external dependencies for run-time compiler.");
        try {
            file = new File(this.denizen.getDataFolder() + File.separator + "externals" + File.separator + "dependencies");
            files = file.listFiles();
            if (files.length > 0) {
                for (File f : files) {
                    fileName = f.getName();
                    if (!fileName.substring(fileName.lastIndexOf(46) + 1).equalsIgnoreCase("JAR")) continue;
                    dependencies.add(f.getPath());
                    dB.echoDebug("Loaded  " + f.getName());
                }
            }
        }
        catch (Exception error) {
            dB.log("No dependencies to load.");
        }
        try {
            file = new File(this.denizen.getDataFolder() + File.separator + "externals");
            files = file.listFiles();
            if (files.length > 0) {
                for (File f : files) {
                    fileName = f.getName();
                    if (!fileName.substring(fileName.lastIndexOf(46) + 1).equalsIgnoreCase("JAVA") || fileName.startsWith(".")) continue;
                    dB.echoDebug("Processing '" + fileName + "'... ");
                    JavaSourceCompilerImpl javaSourceCompiler = new JavaSourceCompilerImpl();
                    JavaSourceCompiler.CompilationUnit compilationUnit = javaSourceCompiler.createCompilationUnit();
                    if (!dependencies.isEmpty()) {
                        compilationUnit.addClassPathEntries(dependencies);
                    }
                    try {
                        compilationUnit.addJavaSource(fileName.replace(".java", ""), this.readFile(f.getAbsolutePath()));
                        ClassLoader classLoader = javaSourceCompiler.compile(compilationUnit, new String[0]);
                        Class<?> load = classLoader.loadClass(fileName.replace(".java", ""));
                        ExternalDenizenClass loadedClass = (ExternalDenizenClass)load.newInstance();
                        loadedClass.load();
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalStateException) {
                            dB.echoError("No JDK found! External .java files will not be loaded.");
                            continue;
                        }
                        dB.echoError(ChatColor.RED + "Woah! Error compiling " + fileName + "!");
                        e.printStackTrace();
                    }
                }
                dB.echoApproval("All externals loaded!");
            } else {
                dB.echoError("Woah! No externals in /plugins/Denizen/externals/.../ to load!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String readFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }
}

