/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import java.util.List;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.listeners.core.TravelListenerType;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TravelListenerInstance
extends AbstractListener
implements Listener {
    public static final String DISTANCE_ARG = "DISTANCE, D";
    public static final String TYPE_ARG = "TYPE";
    public static final String TARGET_ARG = "TARGET";
    public static final String RADIUS_ARG = "RADIUS, R";
    private NPC target;
    private Location endPoint;
    private Integer blocksWalked = 0;
    private Integer distance = null;
    private Integer radius = 2;
    private TravelListenerType.TravelType type;

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @Override
    public void deconstructed() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public void onBuild(List<String> args) {
        for (String arg : args) {
            if (aH.matchesLocation(arg)) {
                this.endPoint = aH.getLocationFrom(arg);
                dB.echoDebug("...ending location set");
                continue;
            }
            if (aH.matchesValueArg(DISTANCE_ARG, arg, aH.ArgumentType.Integer)) {
                this.distance = aH.getIntegerFrom(arg);
                dB.echoDebug("...distance set to: " + this.distance);
                continue;
            }
            if (aH.matchesValueArg(RADIUS_ARG, arg, aH.ArgumentType.Integer)) {
                this.radius = aH.getIntegerFrom(arg);
                dB.echoDebug("...radius set to: " + this.radius);
                continue;
            }
            if (aH.matchesValueArg(TYPE_ARG, arg, aH.ArgumentType.Custom)) {
                try {
                    this.type = TravelListenerType.TravelType.valueOf(aH.getStringFrom(arg));
                    dB.echoDebug("...set TYPE to: " + aH.getStringFrom(arg));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!aH.matchesValueArg(TARGET_ARG, arg, aH.ArgumentType.LivingEntity) || CitizensAPI.getNPCRegistry().getNPC((Entity)aH.getLivingEntityFrom(arg)) == null || !CitizensAPI.getNPCRegistry().isNPC((Entity)aH.getLivingEntityFrom(arg))) continue;
            this.target = CitizensAPI.getNPCRegistry().getNPC((Entity)aH.getLivingEntityFrom(arg));
            dB.echoDebug("...NPC set to: " + this.target.getId());
        }
        if (this.type == null) {
            dB.echoError("Missing TYPE argument! Valid: DISTANCE, TOLOCATION, TONPC");
            this.cancel();
        }
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onLoad() {
        this.type = TravelListenerType.TravelType.valueOf((String)this.get("Type"));
        this.distance = (Integer)this.get("Distance");
        this.blocksWalked = (Integer)this.get("Blocks Walked");
        this.endPoint = (Location)this.get("End Location");
    }

    @Override
    public void onSave() {
        this.store("Type", this.type.name());
        this.store("Distance", this.distance);
        this.store("Radius", this.radius);
        this.store("Blocks Walked", this.blocksWalked);
        this.store("End Location", this.endPoint);
    }

    @Override
    public String report() {
        if (this.type == TravelListenerType.TravelType.DISTANCE) {
            return this.player.getName() + "has traveled " + this.blocksWalked + " blocks out of " + this.distance;
        }
        if (this.type == TravelListenerType.TravelType.TOLOCATION) {
            return this.player.getName() + " is traveling to " + this.endPoint;
        }
        if (this.type == TravelListenerType.TravelType.TONPC) {
            return this.player.getName() + " is traveling to NPC " + this.target.getId();
        }
        return "Failed to create detailed report";
    }

    @EventHandler
    public void walking(PlayerMoveEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        if (this.type == TravelListenerType.TravelType.DISTANCE) {
            if (!event.getTo().getBlock().equals(event.getFrom().getBlock())) {
                Integer n = this.blocksWalked;
                Integer n2 = this.blocksWalked = Integer.valueOf(this.blocksWalked + 1);
                dB.echoDebug("..player moved a block");
                this.check();
            }
        } else if (this.type == TravelListenerType.TravelType.TOLOCATION) {
            if (this.player.getLocation().distance(this.endPoint) <= (double)this.radius.intValue()) {
                dB.echoDebug("...player reached location");
                this.finish();
            }
        } else if (this.type == TravelListenerType.TravelType.TONPC && this.player.getLocation().distance(this.target.getBukkitEntity().getLocation()) <= (double)this.radius.intValue()) {
            dB.echoDebug("...player reached NPC");
            this.finish();
        }
    }

    private void check() {
        if (this.blocksWalked >= this.distance) {
            this.finish();
        }
    }
}

