/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc;

import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.npc.traits.NicknameTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.commands.core.EngageCommand;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import net.minecraft.server.v1_4_R1.EntityLiving;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftLivingEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dNPC {
    private int npcid;

    dNPC(NPC citizensNPC) {
        this.npcid = citizensNPC.getId();
    }

    public EntityLiving getHandle() {
        return ((CraftLivingEntity)this.getEntity()).getHandle();
    }

    public NPC getCitizen() {
        NPC npc = CitizensAPI.getNPCRegistry().getById(this.npcid);
        if (npc == null) {
            dB.log("Uh oh! Denizen has encountered an NPE while trying to fetch a NPC. Has this NPC been removed?");
        }
        return npc;
    }

    public LivingEntity getEntity() {
        try {
            return this.getCitizen().getBukkitEntity();
        }
        catch (NullPointerException e) {
            dB.log("Uh oh! Denizen has encountered an NPE while trying to fetch a NPC entity. Has this NPC been removed?");
            return null;
        }
    }

    public EntityType getEntityType() {
        return this.getCitizen().getBukkitEntity().getType();
    }

    public Navigator getNavigator() {
        return this.getCitizen().getNavigator();
    }

    public int getId() {
        return this.getCitizen().getId();
    }

    public String getName() {
        return this.getCitizen().getName();
    }

    public InteractScriptContainer getInteractScript(Player player, Class<? extends AbstractTrigger> triggerType) {
        return InteractScriptHelper.getInteractScript(this, player, triggerType);
    }

    public InteractScriptContainer getInteractScriptQuietly(Player player, Class<? extends AbstractTrigger> triggerType) {
        boolean db = dB.debugMode;
        dB.debugMode = false;
        InteractScriptContainer script = InteractScriptHelper.getInteractScript(this, player, triggerType);
        dB.debugMode = db;
        return script;
    }

    public Location getLocation() {
        if (this.isSpawned()) {
            return new Location(this.getCitizen().getBukkitEntity().getLocation());
        }
        return null;
    }

    public Location getEyeLocation() {
        if (this.isSpawned()) {
            return new Location(this.getCitizen().getBukkitEntity().getEyeLocation());
        }
        return null;
    }

    public World getWorld() {
        if (this.isSpawned()) {
            return this.getEntity().getWorld();
        }
        return null;
    }

    public String toString() {
        return this.getCitizen().getName() + "/" + this.getCitizen().getId();
    }

    public boolean isEngaged() {
        return EngageCommand.getEngaged(this.getCitizen());
    }

    public boolean isSpawned() {
        return this.getCitizen().isSpawned();
    }

    public boolean isVulnerable() {
        return true;
    }

    public String getOwner() {
        return ((Owner)this.getCitizen().getTrait(Owner.class)).getOwner();
    }

    public AssignmentTrait getAssignmentTrait() {
        if (!this.getCitizen().hasTrait(AssignmentTrait.class)) {
            this.getCitizen().addTrait(AssignmentTrait.class);
        }
        return (AssignmentTrait)this.getCitizen().getTrait(AssignmentTrait.class);
    }

    public NicknameTrait getNicknameTrait() {
        if (!this.getCitizen().hasTrait(NicknameTrait.class)) {
            this.getCitizen().addTrait(NicknameTrait.class);
        }
        return (NicknameTrait)this.getCitizen().getTrait(NicknameTrait.class);
    }

    public HealthTrait getHealthTrait() {
        if (!this.getCitizen().hasTrait(HealthTrait.class)) {
            this.getCitizen().addTrait(HealthTrait.class);
        }
        return (HealthTrait)this.getCitizen().getTrait(HealthTrait.class);
    }

    public TriggerTrait getTriggerTrait() {
        if (!this.getCitizen().hasTrait(TriggerTrait.class)) {
            this.getCitizen().addTrait(TriggerTrait.class);
        }
        return (TriggerTrait)this.getCitizen().getTrait(TriggerTrait.class);
    }

    public void action(String actionName, Player player) {
        if (this.getCitizen() != null && this.getCitizen().hasTrait(AssignmentTrait.class)) {
            DenizenAPI.getCurrentInstance().getNPCRegistry().getActionHandler().doAction(actionName, this, player, this.getAssignmentTrait().getAssignment());
        }
    }

    @Deprecated
    public String getAssignment() {
        if (this.getCitizen().hasTrait(AssignmentTrait.class)) {
            return ((AssignmentTrait)this.getCitizen().getTrait(AssignmentTrait.class)).getAssignment().getName();
        }
        return null;
    }

    @Deprecated
    public boolean hasAssignment() {
        if (!this.getCitizen().hasTrait(AssignmentTrait.class)) {
            return false;
        }
        return ((AssignmentTrait)this.getCitizen().getTrait(AssignmentTrait.class)).hasAssignment();
    }

    @Deprecated
    public boolean setAssignment(String assignment, Player player) {
        if (!this.getCitizen().hasTrait(AssignmentTrait.class)) {
            this.getCitizen().addTrait(AssignmentTrait.class);
        }
        return ((AssignmentTrait)this.getCitizen().getTrait(AssignmentTrait.class)).setAssignment(assignment, player);
    }

    @Deprecated
    public boolean isInteracting() {
        DenizenAPI._commandRegistry().get(EngageCommand.class);
        return !EngageCommand.getEngaged(this.getCitizen());
    }
}

