/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class ExecuteCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String command = null;
        Type executeType = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("ASPLAYER, AS_PLAYER", arg)) {
                executeType = Type.AS_PLAYER;
                continue;
            }
            if (aH.matchesArg("ASOPPLAYER, ASOP, AS_OP, AS_OP_PLAYER", arg)) {
                executeType = Type.AS_OP;
                continue;
            }
            if (aH.matchesArg("ASNPC, AS_NPC", arg)) {
                executeType = Type.AS_NPC;
                continue;
            }
            if (aH.matchesArg("ASSERVER, AS_SERVER", arg)) {
                executeType = Type.AS_SERVER;
                continue;
            }
            command = arg;
        }
        if (executeType == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "EXECUTE_TYPE");
        }
        if (command == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "COMMAND_TEXT");
        }
        scriptEntry.addObject("command", command).addObject("type", (Object)executeType);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String command = (String)scriptEntry.getObject("command");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        dB.report(this.getName(), aH.debugObj("Type", type.toString()) + aH.debugObj("Command", command));
        switch (type) {
            case AS_PLAYER: {
                scriptEntry.getPlayer().performCommand(command);
                return;
            }
            case AS_OP: {
                boolean isOp = false;
                if (scriptEntry.getPlayer().isOp()) {
                    isOp = true;
                }
                if (!isOp) {
                    scriptEntry.getPlayer().setOp(true);
                }
                scriptEntry.getPlayer().performCommand(command);
                if (!isOp) {
                    scriptEntry.getPlayer().setOp(false);
                }
                return;
            }
            case AS_NPC: {
                if (scriptEntry.getNPC().getEntity().getType() != EntityType.PLAYER) {
                    throw new CommandExecutionException("Cannot EXECUTE AS_NPC unless the NPC is Player-Type.");
                }
                ((Player)scriptEntry.getNPC().getEntity()).setOp(true);
                ((Player)scriptEntry.getNPC().getEntity()).performCommand(command);
                ((Player)scriptEntry.getNPC().getEntity()).setOp(false);
                return;
            }
            case AS_SERVER: {
                this.denizen.getServer().dispatchCommand((CommandSender)this.denizen.getServer().getConsoleSender(), command);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        AS_SERVER,
        AS_NPC,
        AS_PLAYER,
        AS_OP;

    }
}

