/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.npc.traits.NameplateTrait;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;

public class NameplateCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        dNPC npc = scriptEntry.getNPC();
        if (npc.getCitizen().hasTrait(NameplateTrait.class)) {
            ChatColor color = null;
            String playerName = null;
            List<String> args = scriptEntry.getArguments();
            for (String arg : args) {
                if (aH.matchesValueArg("COLOR", arg, aH.ArgumentType.String)) {
                    String cString = aH.getStringFrom(arg).toUpperCase();
                    try {
                        color = ChatColor.valueOf((String)cString.toUpperCase());
                        dB.echoDebug("...COLOR set: '%s'", cString);
                    }
                    catch (Exception e) {
                        dB.echoDebug("...COLOR could not be set: '%s' is an invalid color!", cString);
                    }
                    continue;
                }
                if (!aH.matchesValueArg("PLAYER", arg, aH.ArgumentType.String)) continue;
                playerName = aH.getStringFrom(arg);
                dB.echoDebug("...PLAYER set: '%s'", arg);
            }
            scriptEntry.addObject("color", color);
            scriptEntry.addObject("player", playerName);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dNPC npc = scriptEntry.getNPC();
        ChatColor color = (ChatColor)scriptEntry.getObject("color");
        if (color != null && npc.getCitizen().hasTrait(NameplateTrait.class)) {
            NameplateTrait trait = (NameplateTrait)npc.getCitizen().getTrait(NameplateTrait.class);
            String playerName = (String)scriptEntry.getObject("player");
            if (playerName != null) {
                trait.setColor(color, playerName);
            } else {
                trait.setColor(color);
            }
        }
    }
}

