/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.trait.Poses;

public class PoseCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = Action.ASSUME;
        String id = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("ADD, ASSUME, REMOVE", arg)) {
                action = Action.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            if (aH.matchesValueArg("ID", arg, aH.ArgumentType.String)) {
                id = aH.getStringFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT);
        }
        scriptEntry.addObject("action", (Object)action).addObject("id", id);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        String id = (String)scriptEntry.getObject("id");
        dB.report(this.getName(), aH.debugObj("NPC", scriptEntry.getNPC().toString()) + aH.debugObj("Action", action.toString()) + aH.debugObj("Id", id));
        dNPC npc = scriptEntry.getNPC();
        switch (action) {
            case ASSUME: {
                ((Poses)npc.getCitizen().getTrait(Poses.class)).assumePose(id);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE,
        ASSUME;

    }
}

