/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class QueueCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ScriptQueue queue = scriptEntry.getResidingQueue();
        Action action = null;
        Duration delay = null;
        ArrayList<ScriptQueue> queues = new ArrayList<ScriptQueue>();
        queues.add(scriptEntry.getResidingQueue());
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesQueue(arg)) {
                queues.clear();
                for (String queueName : aH.getListFrom(arg)) {
                    try {
                        queues.add(aH.getQueueFrom(queueName));
                    }
                    catch (Exception e) {}
                }
                continue;
            }
            if (aH.matchesArg("CLEAR, SET, PAUSE, RESUME", arg)) {
                action = Action.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            if (aH.matchesValueArg("DELAY", arg, aH.ArgumentType.Duration)) {
                action = Action.DELAY;
                delay = aH.getDurationFrom(arg);
                continue;
            }
            queues.clear();
            for (String queueName : aH.getListFrom(arg)) {
                try {
                    queues.add(aH.getQueueFrom(queueName));
                }
                catch (Exception e) {}
            }
        }
        if (action == null) {
            throw new InvalidArgumentsException("Must specify an action. Valid: CLEAR, SET, DELAY, PAUSE, RESUME");
        }
        if (action == Action.DELAY && delay == null) {
            throw new InvalidArgumentsException("Must specify a delay.");
        }
        scriptEntry.addObject("queue", queue).addObject("action", (Object)action).addObject("delay", delay);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List queues = (List)scriptEntry.getObject("queues");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        Duration delay = (Duration)scriptEntry.getObject("duration");
        dB.report(this.getName(), aH.debugObj("Queues", queues.toString()) + aH.debugObj("Action", action.toString()) + (action != null && action == Action.DELAY ? delay.debug() : ""));
        switch (action) {
            case CLEAR: {
                for (ScriptQueue queue : queues) {
                    queue.clear();
                }
                return;
            }
            case PAUSE: {
                for (ScriptQueue queue : queues) {
                    queue.setPaused(true);
                }
                return;
            }
            case RESUME: {
                for (ScriptQueue queue : queues) {
                    queue.setPaused(false);
                }
                return;
            }
            case DELAY: {
                for (ScriptQueue queue : queues) {
                    queue.delayFor(delay.getTicks());
                }
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        CLEAR,
        SET,
        DELAY,
        PAUSE,
        RESUME;

    }
}

