/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.text.DecimalFormat;
import net.aufdemrand.denizen.interfaces.dScriptArgument;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;

public class Element
implements dScriptArgument {
    private String prefix;
    private String element;

    public static Element valueOf(String string) {
        if (string == null) {
            return null;
        }
        String prefix = null;
        if (string.split(":").length > 1) {
            prefix = string.split(":", 2)[0];
            string = string.split(":", 2)[1];
        }
        return new Element(prefix, string);
    }

    public Element(String string) {
        this.prefix = this.element;
        this.element = string;
    }

    public Element(String prefix, String string) {
        this.prefix = prefix == null ? "element" : prefix;
        this.element = string;
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.element + "<G>'  ";
    }

    public String as_dScriptArg() {
        return this.prefix + ":" + this.element;
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("asint")) {
            try {
                return new Element(String.valueOf(Integer.valueOf(this.element))).getAttribute(attribute.fulfill(1));
            }
            catch (NumberFormatException e) {
                dB.echoError("'" + this.element + "' is not a valid Integer.");
            }
        }
        if (attribute.startsWith("asdouble")) {
            try {
                return new Element(String.valueOf(Double.valueOf(this.element))).getAttribute(attribute.fulfill(1));
            }
            catch (NumberFormatException e) {
                dB.echoError("'" + this.element + "' is not a valid Double.");
            }
        }
        if (attribute.startsWith("asmoney")) {
            try {
                DecimalFormat d = new DecimalFormat("0.00");
                return new Element(String.valueOf(d.format(Double.valueOf(this.element)))).getAttribute(attribute.fulfill(1));
            }
            catch (NumberFormatException e) {
                dB.echoError("'" + this.element + "' is not a valid Money format.");
            }
        }
        if (attribute.startsWith("asboolean")) {
            return new Element(Boolean.valueOf(this.element).toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("substring")) {
            int beginning_index = Integer.valueOf(attribute.getContext(1).split("\\|")[0]) - 1;
            int ending_index = Integer.valueOf(attribute.getContext(1).split("\\|")[1]) - 1;
            return new Element(String.valueOf(this.element.substring(beginning_index, ending_index))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        return this.element;
    }
}

