/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.core.NewCommand;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.Script;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class aH {
    static final Pattern doublePtrn = Pattern.compile("(?:-|)(?:(?:\\d+)|)(?:(?:\\.\\d+)|)");
    static final Pattern floatPtrn = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
    static final Pattern integerPtrn = Pattern.compile("(?:-|)\\d+");
    static final Pattern wordPtrn = Pattern.compile("\\w+");
    private static final Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");

    public static String debugObj(String prefix, String value) {
        return "<G>" + prefix + "='<Y>" + value + "<G>'  ";
    }

    public static String debugUniqueObj(String prefix, String id, String value) {
        return "<G>" + prefix + "='<A>" + id + "<Y>(" + value + ")<G>'  ";
    }

    public static boolean matchesArg(String names, String arg) {
        if (names.split(",").length == 1) {
            if (arg.toUpperCase().equals(names.toUpperCase())) {
                return true;
            }
        } else {
            for (String string : names.split(",")) {
                if (!arg.split(":")[0].equalsIgnoreCase(string.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchesValueArg(String names, String arg, ArgumentType type) {
        if (arg == null) {
            return false;
        }
        if (arg.split(":").length == 1) {
            return false;
        }
        if (names.split(",").length == 1) {
            if (!arg.split(":")[0].equalsIgnoreCase(names)) {
                return false;
            }
        } else {
            boolean matched = false;
            for (String string : names.split(",")) {
                if (!arg.split(":")[0].equalsIgnoreCase(string.trim())) continue;
                matched = true;
            }
            if (!matched) {
                return false;
            }
        }
        arg = arg.split(":", 2)[1];
        switch (type) {
            case Word: {
                Matcher m = wordPtrn.matcher(arg);
                if (!m.matches()) break;
                return true;
            }
            case Integer: {
                Matcher m = integerPtrn.matcher(arg);
                if (!m.matches()) break;
                return true;
            }
            case Double: {
                Matcher m = doublePtrn.matcher(arg);
                if (!m.matches()) break;
                return true;
            }
            case Float: {
                Matcher m = floatPtrn.matcher(arg);
                if (!m.matches()) break;
                return true;
            }
            case Boolean: {
                if (arg.equalsIgnoreCase("true")) {
                    return true;
                }
                if (!arg.equalsIgnoreCase("false")) break;
                return false;
            }
            case Location: {
                return aH.matchesLocation("location:" + arg);
            }
            case Script: {
                return aH.matchesLocation("script:" + arg);
            }
            case Item: {
                return aH.matchesItem("item:" + arg);
            }
            case LivingEntity: {
                Pattern matchesEntityPtrn = Pattern.compile("(?:.+?|):((ENTITY\\.|PLAYER\\.|NPC\\.).+)|(PLAYER|NPC)", 2);
                Matcher m = matchesEntityPtrn.matcher(arg);
                if (!m.matches()) break;
                return true;
            }
            case Duration: {
                return aH.matchesDuration("duration:" + arg);
            }
            default: {
                return true;
            }
        }
        dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. Check documentation for valid value." + "Perhaps a replaceable Tag has failed to fill in a value?");
        return false;
    }

    public static boolean getBooleanFrom(String arg) {
        if (arg.split(":").length >= 2) {
            return Boolean.valueOf(arg.split(":", 2)[1]);
        }
        return Boolean.valueOf(arg);
    }

    public static double getDoubleFrom(String arg) {
        try {
            if (arg.split(":").length >= 2) {
                return Double.valueOf(arg.split(":", 2)[1]);
            }
            return Double.valueOf(arg);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static EntityType getEntityFrom(String arg) {
        Pattern matchesEntityPtrn = Pattern.compile("(?:(?:.+?:)|)(.+)", 2);
        Matcher m = matchesEntityPtrn.matcher(arg);
        if (m.matches()) {
            for (EntityType validEntity : EntityType.values()) {
                if (!m.group(1).equalsIgnoreCase(validEntity.name())) continue;
                return validEntity;
            }
        }
        return null;
    }

    public static LivingEntity getLivingEntityFrom(String arg) {
        Pattern matchesEntityPtrn = Pattern.compile("(?:(?:.+?:)|)(.+)", 2);
        Matcher m = matchesEntityPtrn.matcher(arg);
        if (m.matches()) {
            if (m.group(1).toUpperCase().startsWith("ENTITY.")) {
                LivingEntity returnable = ((Denizen)Bukkit.getPluginManager().getPlugin("Denizen")).getCommandRegistry().get(NewCommand.class).getEntity(m.group(1).split("\\.")[1]);
                if (returnable != null) {
                    return returnable;
                }
                dB.echoError("Invalid entity! '" + m.group(1) + "' could not be found.");
            } else if (m.group(1).toUpperCase().startsWith("NPC.")) {
                LivingEntity returnable = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(m.group(1).split("\\.")[1]).intValue()).getBukkitEntity();
                if (returnable != null) {
                    return returnable;
                }
                dB.echoError("Invalid NPC! '" + m.group(1) + "' could not be found.");
            } else if (m.group(1).toUpperCase().startsWith("PLAYER.")) {
                Player returnable = aH.getPlayerFrom(m.group(1).split("\\.")[1]);
                if (returnable != null) {
                    return returnable;
                }
                dB.echoError("Invalid Player! '" + m.group(1) + "' could not be found.");
            }
        }
        return null;
    }

    public static float getFloatFrom(String arg) {
        try {
            if (arg.split(":").length >= 2) {
                return Float.valueOf(arg.split(":", 2)[1]).floatValue();
            }
            return Float.valueOf(arg).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static int getIntegerFrom(String arg) {
        try {
            if (arg.split(":").length >= 2) {
                return Integer.valueOf(arg.split(":", 2)[1]);
            }
            return Integer.valueOf(arg);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static Item getItemFrom(String arg) {
        if (arg == null) {
            return null;
        }
        Item stack = Item.valueOf(arg);
        if (stack == null) {
            dB.echoError("Invalid item! Failed to find a matching Bukkit ItemStack.");
        }
        return stack;
    }

    public static List<String> getListFrom(String arg) {
        if (arg == null || arg.equals("")) {
            return new ArrayList<String>();
        }
        if (arg.split(":").length >= 2) {
            return Arrays.asList(arg.split(":", 2)[1].split("\\|"));
        }
        return Arrays.asList(arg.split("\\|"));
    }

    public static Location getLocationFrom(String arg) {
        Location location = Location.valueOf(arg);
        if (location == null) {
            dB.echoError("Unable to build a location with this information! Provided: '" + arg + "'.");
        }
        return location;
    }

    public static Script getScriptFrom(String arg) {
        Script script = Script.valueOf(arg);
        if (script == null) {
            dB.echoError("Unable to build a script with this information! Provided: '" + arg + "'.");
        }
        return script;
    }

    public static Player getPlayerFrom(String arg) {
        if (arg.split(":").length >= 2) {
            arg = arg.split(":", 2)[1];
        }
        if (arg.toUpperCase().contains("PLAYER.")) {
            arg = arg.toUpperCase().replace("PLAYER.", "");
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(arg)) continue;
            return player;
        }
        dB.echoError("Player '" + arg + "' is invalid, or offline.");
        return null;
    }

    public static NPC getNPCFrom(String arg) {
        if (arg.split(":").length >= 2) {
            arg = arg.split(":", 2)[1];
        }
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (npc.getId() != Integer.valueOf(arg).intValue()) continue;
            return npc;
        }
        dB.echoError("NPC '" + arg + "' is invalid, or has been removed.");
        return null;
    }

    public static OfflinePlayer getOfflinePlayerFrom(String arg) {
        if (arg.split(":").length >= 2) {
            arg = arg.split(":", 2)[1];
        }
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            if (!player.getName().equalsIgnoreCase(arg)) continue;
            return player;
        }
        dB.echoError("OfflinePlayer '" + arg + "' is invalid, or has never logged in to this server.");
        return null;
    }

    public static ScriptQueue getQueueFrom(String arg) {
        if (arg.split(":").length >= 2) {
            return ScriptQueue._getQueue(arg.split(":")[1].toUpperCase());
        }
        return ScriptQueue._getQueue(arg.toUpperCase());
    }

    public static String getStringFrom(String arg) {
        if (arg.split(":").length >= 2 && (arg.indexOf(58) < arg.indexOf(32) || arg.indexOf(32) == -1)) {
            return arg.split(":", 2)[1];
        }
        return arg;
    }

    public static Duration getDurationFrom(String arg) {
        Duration duration = Duration.valueOf(arg);
        if (duration == null) {
            dB.echoError("Unable to build a duration with this information! Provided: '" + arg + "'.");
        }
        return duration;
    }

    public static boolean matchesDouble(String arg) {
        Matcher m = doublePtrn.matcher(arg);
        return m.matches();
    }

    public static boolean matchesDuration(String arg) {
        Pattern matchesDurationPtrn = Pattern.compile("(?:duration:)(\\d+|\\.\\d+|\\d+\\.\\d+)(|t|m|s|h|d)", 2);
        Matcher m = matchesDurationPtrn.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("DURATION:")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. 'DURATION' requires a positive integer value. " + "Perhaps a replaceable Tag has failed to fill in a valid value?");
        }
        return false;
    }

    public static boolean matchesEntityType(String arg) {
        Pattern matchesEntityPtrn = Pattern.compile("entity:(.+)", 2);
        Matcher m = matchesEntityPtrn.matcher(arg);
        if (m.matches()) {
            for (EntityType validEntity : EntityType.values()) {
                if (!m.group(1).equalsIgnoreCase(validEntity.name())) continue;
                return true;
            }
            for (EntityType validEntity : EntityType.values()) {
                if (!m.group(1).equalsIgnoreCase(validEntity.name())) continue;
                return true;
            }
        }
        if (arg.toUpperCase().startsWith("entity:")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. Perhaps a replaceable Tag has failed " + "to fill in a valid EntityType, or the EntityType you provided is not correct?");
        }
        return false;
    }

    public static boolean matchesInteger(String arg) {
        Matcher m = integerPtrn.matcher(arg);
        return m.matches();
    }

    public static boolean matchesItem(String arg) {
        return arg.toUpperCase().startsWith("ITEM:") && arg.length() > 5;
    }

    public static boolean matchesContext(String arg) {
        return arg.toUpperCase().startsWith("CONTEXT:");
    }

    public static Map<String, String> getContextFrom(String arg) {
        HashMap<String, String> context = new HashMap<String, String>();
        List<String> contexts = aH.getListFrom(arg);
        int x = 1;
        for (String ctxt : contexts) {
            context.put(String.valueOf(x), ctxt.trim());
            ++x;
        }
        return context;
    }

    public static boolean matchesLocation(String arg) {
        Pattern locationPattern = Pattern.compile("location:(?:-|)(?:\\d+|\\d+\\.\\d+),(?:-|)(?:\\d+|\\d+\\.\\d+),(?:-|)(?:\\d+|\\d+\\.\\d+),\\w+", 2);
        Matcher m = locationPattern.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("location:")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. Perhaps a replaceable Tag has failed " + "to fill in a valid location?");
        }
        return false;
    }

    public static boolean matchesQuantity(String arg) {
        Pattern matchesQuantityPtrn = Pattern.compile("qty:(?:-|)\\d+", 2);
        Matcher m = matchesQuantityPtrn.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("qty:")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. 'QTY' requires a an integer value. " + "Perhaps a replaceable Tag has failed to fill in a valid value?");
        }
        return false;
    }

    public static boolean matchesQueue(String arg) {
        Pattern matchesQueuePtrn = Pattern.compile("queue:(.+)", 2);
        Matcher m = matchesQueuePtrn.matcher(arg);
        return m.matches();
    }

    public static boolean matchesScript(String arg) {
        Pattern matchesScriptPtrn = Pattern.compile("script:(.+)", 2);
        Matcher m = matchesScriptPtrn.matcher(arg);
        if (m.matches()) {
            if (ScriptRegistry.containsScript(m.group(1))) {
                return true;
            }
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. This " + "argument's format is correct, but Denizen couldn't locate a script " + "named '" + m.group(1) + "'. Is it spelled correctly?");
        }
        return false;
    }

    public static boolean matchesToggle(String arg) {
        Pattern matchesTogglePtrn = Pattern.compile("toggle:(?:(?:true)|(?:false)|(?:toggle))", 2);
        Matcher m = matchesTogglePtrn.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("toggle:")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. 'TOGGLE' requires a value of TRUE, FALSE, or TOGGLE. " + "Perhaps a replaceable Tag has failed to fill in a valid value?");
        }
        return false;
    }

    public static String[] buildArgs(String stringArgs) {
        if (stringArgs == null) {
            return null;
        }
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher regexMatcher = regex.matcher(stringArgs);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        if (dB.showScriptBuilder) {
            dB.echoDebug(ChatColor.GRAY + "Args: " + Arrays.toString(matchList.toArray()));
        }
        String[] split = new String[matchList.size()];
        matchList.toArray(split);
        return split;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgumentType {
        LivingEntity,
        Item,
        Boolean,
        Custom,
        Double,
        Float,
        Integer,
        String,
        Word,
        Location,
        Script,
        Duration;

    }
}

