/*
 * Decompiled with CFR 0.152.
 */
package org.shade.abstractmeta.toolbox.compilation.compiler.util;

import java.net.URI;
import java.net.URISyntaxException;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class URIUtil {
    public static String SOURCE_CODE_URI_TEMPLATE = "string:///%s%s";
    public static String CLASS_CODE_URI_TEMPLATE = "bytecode:///%s%s";

    public static URI buildUri(JavaFileManager.Location location, String name) {
        String extension = "";
        String template = location.getName().toLowerCase().replace("_", "") + ":///%s%s";
        if (location == StandardLocation.CLASS_OUTPUT) {
            extension = JavaFileObject.Kind.CLASS.extension;
            template = CLASS_CODE_URI_TEMPLATE;
        } else if (location == StandardLocation.SOURCE_OUTPUT) {
            extension = JavaFileObject.Kind.SOURCE.extension;
            template = SOURCE_CODE_URI_TEMPLATE;
        }
        int dotLastPosition = name.lastIndexOf(46);
        if (dotLastPosition != -1) {
            name = name.replace('.', '/');
        }
        return URIUtil.buildUri(String.format(template, name, extension));
    }

    public static URI buildUri(JavaFileManager.Location location, String packageName, String simpleClassName) {
        if (packageName.isEmpty()) {
            return URIUtil.buildUri(location, simpleClassName);
        }
        return URIUtil.buildUri(location, packageName + "." + simpleClassName);
    }

    public static URI buildUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("Failed to build uri: %s", uri));
        }
    }
}

