/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.HungerTrait;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class FeedCommand
extends AbstractCommand {
    private int amount;
    private LivingEntity target;
    private TargetType targetType;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.targetType = TargetType.PLAYER;
        this.amount = Integer.MAX_VALUE;
        this.target = scriptEntry.getPlayer() != null ? scriptEntry.getPlayer() : null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesQuantity(arg) || aH.matchesValueArg("amt", arg, aH.ArgumentType.Integer)) {
                this.amount = aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_QUANTITY, String.valueOf(this.amount));
                continue;
            }
            if (aH.matchesValueArg("target", arg, aH.ArgumentType.String)) {
                try {
                    this.targetType = TargetType.valueOf(aH.getStringFrom(arg));
                    dB.echoDebug("TARGET to FEED: " + this.targetType.name());
                }
                catch (Exception e) {
                    dB.echoError("Invalid TARGET! Valid: NPC, PLAYER");
                }
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (this.targetType == TargetType.PLAYER && scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (this.targetType == TargetType.NPC && scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        if (this.targetType == TargetType.NPC) {
            this.target = scriptEntry.getNPC().getEntity();
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        if (CitizensAPI.getNPCRegistry().isNPC((Entity)this.target)) {
            NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)this.target);
            if (!npc.hasTrait(HungerTrait.class)) {
                throw new CommandExecutionException("This NPC does not have the HungerTrait enabled! Use /trait hunger");
            }
            if (this.amount == Integer.MAX_VALUE) {
                ((HungerTrait)npc.getTrait(HungerTrait.class)).setHunger(0.0);
            } else {
                ((HungerTrait)npc.getTrait(HungerTrait.class)).feed(this.amount);
            }
        } else if (this.amount == Integer.MAX_VALUE) {
            ((Player)this.target).setFoodLevel(20);
        } else {
            ((Player)this.target).setFoodLevel(((Player)this.target).getFoodLevel() + this.amount);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TargetType {
        NPC,
        PLAYER;

    }
}

