/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Sound;

public class PlaySoundCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Sound sound = null;
        float volume = 1.0f;
        float pitch = 1.0f;
        Location location = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("SOUND", arg, aH.ArgumentType.Custom) || aH.matchesValueArg("S", arg, aH.ArgumentType.Custom)) {
                try {
                    sound = Sound.valueOf((String)aH.getStringFrom(arg).toUpperCase());
                }
                catch (Exception e) {
                    dB.echoError("Invalid SOUND!");
                }
                continue;
            }
            if (aH.matchesValueArg("VOLUME, V", arg, aH.ArgumentType.Float)) {
                volume = aH.getFloatFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("PITCH, P", arg, aH.ArgumentType.Float)) {
                pitch = aH.getFloatFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (sound == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "SOUND");
        }
        if (location == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
        }
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("sound", sound);
        scriptEntry.addObject("volume", Float.valueOf(volume));
        scriptEntry.addObject("pitch", Float.valueOf(pitch));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        org.bukkit.Location location = (org.bukkit.Location)scriptEntry.getObject("location");
        Sound sound = (Sound)scriptEntry.getObject("sound");
        Float volume = (Float)scriptEntry.getObject("volume");
        Float pitch = (Float)scriptEntry.getObject("pitch");
        dB.echoApproval("Executing '" + this.getName() + "': " + "Location='" + location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getWorld().getName() + "', " + "Sound='" + sound.toString() + ", " + "Volume/Pitch='" + volume + "/" + pitch + "'");
        location.getWorld().playSound(location, sound, volume.floatValue(), pitch.floatValue());
    }
}

