/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.minecraft.server.v1_5_R1.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_5_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_5_R1.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    protected static FilenameFilter scriptsFilter = new FilenameFilter(){

        public boolean accept(File file, String fileName) {
            if (fileName.startsWith(".")) {
                return false;
            }
            String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
            return ext.equalsIgnoreCase("YML") || ext.equalsIgnoreCase("DSCRIPT");
        }
    };

    public static Location getWalkableLocationNear(Location location, int range) {
        int selected_z;
        Random range_random = new Random();
        int selected_x = range_random.nextInt(range * 2);
        Location returnable = location.add((double)(selected_x - range), 1.0, (double)((selected_z = range_random.nextInt(range * 2)) - range));
        if (!Utilities.isWalkable(returnable)) {
            return Utilities.getWalkableLocationNear(location, range);
        }
        return returnable;
    }

    public static boolean isWalkable(Location location) {
        return (location.getBlock().getType() == Material.AIR || location.getBlock().getType() == Material.GRASS) && location.add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR;
    }

    public static String arrayToString(String[] input, String glue) {
        String output = "";
        int length = input.length;
        int i = 1;
        for (String s : input) {
            output.concat(s);
            if (++i == length) continue;
            output.concat(glue);
        }
        return output;
    }

    public static void talkToNPC(String message, Player player, dNPC npc, double range) {
        String talkFormat = Settings.ChatToNpcFormat().replace("<TEXT>", message).replace("<text>", message).replace("<Text>", message);
        String bystanderFormat = Settings.ChatToNpcOverheardFormat().replace("<TEXT>", message).replace("<text>", message).replace("<Text>", message);
        DenizenAPI.getCurrentInstance().tagManager();
        talkFormat = TagManager.tag((OfflinePlayer)player, npc, talkFormat, false);
        DenizenAPI.getCurrentInstance().tagManager();
        bystanderFormat = TagManager.tag((OfflinePlayer)player, npc, bystanderFormat, false);
        player.sendMessage(talkFormat);
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target == player || !target.getWorld().equals(player.getWorld()) || !(target.getLocation().distance(player.getLocation()) <= range)) continue;
            target.sendMessage(bystanderFormat);
        }
    }

    public static int lastIndexOfUCL(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfLCL(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public String getVersionNumber() {
        Properties props = new Properties();
        props.put("version", "Unknown development build");
        try {
            props.load(this.getClass().getResourceAsStream("/META-INF/maven/net.aufdemrand/denizen/pom.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props.getProperty("version");
    }

    public static int countItems(Inventory inventory) {
        int qty = 0;
        for (ItemStack invStack : inventory) {
            if (invStack == null) continue;
            qty += invStack.getAmount();
        }
        return qty;
    }

    public static int countItems(ItemStack item, Inventory inventory) {
        int qty = 0;
        for (ItemStack invStack : inventory) {
            if (invStack == null || !invStack.isSimilar(item)) continue;
            qty += invStack.getAmount();
        }
        return qty;
    }

    public static int countItems(String item, Inventory inventory) {
        if (aH.matchesItem("item:" + item)) {
            ItemStack itemstack = new ItemStack((ItemStack)aH.getItemFrom("item:" + item));
            return Utilities.countItems(itemstack, inventory);
        }
        return 0;
    }

    public static void rotate(Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            entity.teleport(location);
            return;
        }
        if (entity instanceof LivingEntity) {
            EntityLiving handle = ((CraftLivingEntity)entity).getHandle();
            handle.yaw = yaw;
            handle.pitch = pitch;
            handle.aA = handle.yaw;
            if (!(entity instanceof Player)) {
                handle.ax = handle.yaw;
            }
        } else {
            net.minecraft.server.v1_5_R1.Entity handle = ((CraftEntity)entity).getHandle();
            handle.yaw = yaw;
            handle.pitch = pitch;
        }
    }

    public static void faceLocation(Entity from, Location at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Location loc = from.getLocation();
        double xDiff = at.getX() - loc.getX();
        double yDiff = at.getY() - loc.getY();
        double zDiff = at.getZ() - loc.getZ();
        double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
        double yaw = Math.toDegrees(Math.acos(xDiff / distanceXZ));
        double pitch = Math.toDegrees(Math.acos(yDiff / distanceY)) - 90.0;
        if (zDiff < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        Utilities.rotate(from, (float)yaw - 90.0f, (float)pitch);
    }

    public static void faceEntity(Entity entity, Entity target) {
        Utilities.faceLocation(entity, target.getLocation());
    }

    public static dNPC getClosestNPC(Location location, int range) {
        dNPC closestNPC = null;
        Double closestDistance = range;
        for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
            if (!npc.getLocation().getWorld().equals(location.getWorld()) || !(npc.getLocation().distance(location) < closestDistance)) continue;
            closestNPC = npc;
            closestDistance = npc.getLocation().distance(location);
        }
        return closestNPC;
    }

    public static Set<dNPC> getClosestNPCs(Location location, int maxRange) {
        HashSet<dNPC> closestNPCs = new HashSet<dNPC>();
        for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
            if (!npc.getLocation().getWorld().equals(location.getWorld()) || !(npc.getLocation().distance(location) < (double)maxRange)) continue;
            closestNPCs.add(npc);
        }
        return closestNPCs;
    }

    public static double normalizeYaw(double yaw) {
        if ((yaw = (yaw - 90.0) % 360.0) < 0.0) {
            yaw += 360.0;
        }
        return yaw;
    }

    public static boolean isFacingLocation(Entity from, Location at, float degreeLimit) {
        double currentYaw = from instanceof Player ? Utilities.normalizeYaw(from.getLocation().getYaw() - 90.0f) : Utilities.normalizeYaw(from.getLocation().getYaw());
        double requiredYaw = Utilities.normalizeYaw(Utilities.getYaw(at.toVector().subtract(from.getLocation().toVector()).normalize()));
        return Math.abs(requiredYaw - currentYaw) < (double)degreeLimit || Math.abs(requiredYaw + 360.0 - currentYaw) < (double)degreeLimit || Math.abs(currentYaw + 360.0 - requiredYaw) < (double)degreeLimit;
    }

    public static boolean isFacingEntity(Entity from, Entity at, float degreeLimit) {
        return Utilities.isFacingLocation(from, at.getLocation(), degreeLimit);
    }

    public static float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI - 90.0);
    }

    public static String getCardinal(double yaw) {
        if (0.0 <= (yaw = Utilities.normalizeYaw(yaw)) && yaw < 22.5) {
            return "north";
        }
        if (22.5 <= yaw && yaw < 67.5) {
            return "northeast";
        }
        if (67.5 <= yaw && yaw < 112.5) {
            return "east";
        }
        if (112.5 <= yaw && yaw < 157.5) {
            return "southeast";
        }
        if (157.5 <= yaw && yaw < 202.5) {
            return "south";
        }
        if (202.5 <= yaw && yaw < 247.5) {
            return "southwest";
        }
        if (247.5 <= yaw && yaw < 292.5) {
            return "west";
        }
        if (292.5 <= yaw && yaw < 337.5) {
            return "northwest";
        }
        if (337.5 <= yaw && yaw < 360.0) {
            return "north";
        }
        return null;
    }

    public static boolean checkLocation(LivingEntity entity, Location theLocation, int theLeeway) {
        if (!entity.getWorld().getName().equals(theLocation.getWorld().getName())) {
            return false;
        }
        Location entityLocation = entity.getLocation();
        if (Math.abs(entityLocation.getX() - theLocation.getX()) > (double)theLeeway) {
            return false;
        }
        if (Math.abs(entityLocation.getY() - theLocation.getY()) > (double)theLeeway) {
            return false;
        }
        return !(Math.abs(entityLocation.getZ() - theLocation.getZ()) > (double)theLeeway);
    }

    public static boolean checkLocation(Location baseLocation, Location theLocation, int theLeeway) {
        if (!baseLocation.getWorld().getName().equals(theLocation.getWorld().getName())) {
            return false;
        }
        Location entityLocation = baseLocation;
        if (Math.abs(entityLocation.getX() - theLocation.getX()) > (double)theLeeway) {
            return false;
        }
        if (Math.abs(entityLocation.getY() - theLocation.getY()) > (double)theLeeway) {
            return false;
        }
        return !(Math.abs(entityLocation.getZ() - theLocation.getZ()) > (double)theLeeway);
    }

    public static List<File> listDScriptFiles(File dir, boolean recursive) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        for (File file : entries = dir.listFiles()) {
            if (scriptsFilter == null || scriptsFilter.accept(dir, file.getName())) {
                files.add(file);
            }
            if (!recursive || !file.isDirectory()) continue;
            files.addAll(Utilities.listDScriptFiles(file, recursive));
        }
        return files;
    }
}

