/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.lang.reflect.Constructor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.interfaces.dScriptArgument;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.arguments.Element;
import net.aufdemrand.denizen.utilities.arguments.List;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.NBTItem;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_5_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Item
extends ItemStack
implements dScriptArgument {
    static final Pattern[] getItemPtrn = new Pattern[]{Pattern.compile("(?:(?:.+?:)|)(\\d+):(\\d+)"), Pattern.compile("(?:(?:.+?:)|)(\\d+)"), Pattern.compile("(?:(?:.+?:)|)([a-zA-Z\\x5F]+?):(\\d+)"), Pattern.compile("(?:(?:.+?:)|)([a-zA-Z\\x5F]+)"), Pattern.compile("(?:(?:.+?:)|)item\\.(.+)", 2), Pattern.compile("(?:(?:.+?:)|)(.+)")};
    private String id;
    private String prefix = "Item";

    public static Item valueOf(String string) {
        return Item.valueOf(string, null, null);
    }

    public static Item valueOf(String string, Player player, dNPC npc) {
        if (string == null) {
            return null;
        }
        Matcher[] m = new Matcher[4];
        Item stack = null;
        m[0] = getItemPtrn[4].matcher(string);
        if (m[0].matches()) {
            // empty if block
        }
        m[0] = getItemPtrn[0].matcher(string);
        m[1] = getItemPtrn[1].matcher(string);
        m[2] = getItemPtrn[2].matcher(string);
        m[3] = getItemPtrn[3].matcher(string);
        try {
            if (m[0].matches()) {
                stack = new Item(Integer.valueOf(m[0].group(1)));
                stack.setDurability(Short.valueOf(m[0].group(2)));
                return stack.setId(stack.getType().name());
            }
            if (m[1].matches()) {
                stack = new Item(Integer.valueOf(m[1].group(1)));
                stack.setId(stack.getType().name());
                return stack;
            }
            if (m[2].matches()) {
                stack = new Item(Material.valueOf((String)m[2].group(1).toUpperCase()));
                stack.setDurability(Short.valueOf(m[2].group(2)));
                return stack.setId(stack.getType().name());
            }
            if (m[3].matches()) {
                stack = new Item(Material.valueOf((String)m[3].group(1).toUpperCase()));
                stack.setId(stack.getType().name());
                return stack;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        m[0] = getItemPtrn[5].matcher(string);
        if (m[0].matches() && ScriptRegistry.containsScript(m[0].group(1), ItemScriptContainer.class)) {
            return ScriptRegistry.getScriptContainerAs(m[0].group(1), ItemScriptContainer.class).getItemFrom(player, npc);
        }
        return stack;
    }

    public Item(Material material) {
        super(material);
        this.setId(this.getType().name());
    }

    public Item(int itemId) {
        super(itemId);
        this.setId(this.getType().name());
    }

    public Item(Material material, int qty) {
        super(material, qty);
        this.setId(this.getType().name());
    }

    public Item(int type, int qty) {
        super(type, qty);
        this.setId(this.getType().name());
    }

    public Item(ItemStack item) {
        super(item);
        this.setId(this.getType().name());
    }

    public ItemStack toCraftBukkit() {
        if (!(this instanceof CraftItemStack)) {
            try {
                Constructor con = CraftItemStack.class.getDeclaredConstructor(ItemStack.class);
                con.setAccessible(true);
                return (ItemStack)con.newInstance(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Item setId(String id) {
        if (NBTItem.hasCustomNBT(this, "denizen-item-id")) {
            this.id = NBTItem.getCustomNBT(this, "denizen-custom-item-id");
        } else {
            this.id = id.toUpperCase();
            NBTItem.addCustomNBT(this, "denizen-item-id", id);
        }
        return this;
    }

    public boolean matches(ItemStack item) {
        return this.matches(new Item(item));
    }

    public boolean matches(Item item) {
        return this.id.equalsIgnoreCase(item.id);
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.id + " seconds<G>'  ";
    }

    public String as_dScriptArg() {
        return this.prefix + ":" + this.id;
    }

    public String dScriptArgValue() {
        return this.getDefaultPrefix().toLowerCase() + ":" + this.as_dScriptArg();
    }

    public String toString() {
        return this.serialize().toString();
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String id = this.id.toLowerCase();
        if (attribute.startsWith("qty")) {
            return new Element(String.valueOf(this.getAmount())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("id")) {
            return new Element(id).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("typeid")) {
            return new Element(String.valueOf(this.getTypeId())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max_stack")) {
            return new Element(String.valueOf(this.getMaxStackSize())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("data")) {
            return new Element(String.valueOf(this.getData().getData())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("durability")) {
            return new Element(String.valueOf(this.getDurability())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("material.formatted")) {
            if (id.equals("air")) {
                return new Element("nothing").getAttribute(attribute.fulfill(2));
            }
            if (id.equals("ice") || id.equals("dirt")) {
                return new Element(id).getAttribute(attribute.fulfill(2));
            }
            if (this.getAmount() > 1) {
                if (id.equals("cactus")) {
                    return new Element("cactuses").getAttribute(attribute.fulfill(2));
                }
                if (id.endsWith("y")) {
                    return new Element(id.substring(0, id.length() - 1) + "ies").getAttribute(attribute.fulfill(2));
                }
                if (id.endsWith("s")) {
                    return new Element(id).getAttribute(attribute.fulfill(2));
                }
                return new Element(id + "s").getAttribute(attribute.fulfill(2));
            }
            if (id.equals("cactus")) {
                return new Element("a cactus").getAttribute(attribute.fulfill(2));
            }
            if (id.endsWith("s")) {
                return new Element(id).getAttribute(attribute.fulfill(2));
            }
            if (id.startsWith("a") || id.startsWith("e") || id.startsWith("i") || id.startsWith("o") || id.startsWith("u")) {
                return new Element("an " + id).getAttribute(attribute.fulfill(2));
            }
            return new Element("a " + id).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("material")) {
            return new Element(this.getType().toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("display") && this.hasItemMeta() && this.getItemMeta().hasDisplayName()) {
            return new Element(this.getItemMeta().getDisplayName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enchantments")) {
            // empty if block
        }
        if (attribute.startsWith("lore")) {
            if (this.hasItemMeta() && this.getItemMeta().hasLore()) {
                return new List(this.getItemMeta().getLore()).getAttribute(attribute.fulfill(1));
            }
            return new List("Empty List", "").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        return new Element(this.dScriptArgValue()).getAttribute(attribute.fulfill(1));
    }
}

