/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.Player;

public class NarrateCommand
extends AbstractCommand {
    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String text = null;
        FormatScriptContainer format = null;
        if (scriptEntry.getArguments().size() > 3) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_LOTS_OF_ARGUMENTS);
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("FORMAT", arg, aH.ArgumentType.String)) {
                String formatStr = aH.getStringFrom(arg);
                format = ScriptRegistry.getScriptContainerAs(formatStr, FormatScriptContainer.class);
                if (format != null) {
                    dB.echoDebug("... format set to: " + formatStr);
                    continue;
                }
                dB.echoError("... could not find format for: " + formatStr);
                continue;
            }
            text = aH.getStringFrom(arg);
        }
        if (scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (text == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_TEXT);
        }
        scriptEntry.addObject("text", text).addObject("format", format);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Player player = scriptEntry.getPlayer();
        String text = (String)scriptEntry.getObject("text");
        FormatScriptContainer format = (FormatScriptContainer)scriptEntry.getObject("format");
        dB.report(this.getName(), aH.debugObj("Player", scriptEntry.getPlayer().getName()) + (format != null ? aH.debugObj("Format", format.getName()) : "") + aH.debugObj("Text", text));
        player.sendMessage(format != null ? format.getFormattedText(scriptEntry) : text);
    }
}

