/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.commands.core.GiveType;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.nbt.NBTItem;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends AbstractCommand {
    Player player;
    GiveType giveType;
    int theAmount;
    Item theItem;
    boolean engrave;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (scriptEntry.getArguments() == null) {
            throw new InvalidArgumentsException("...Usage: GIVE [MONEY|#(:#)|MATERIAL_TYPE(:#)] (QTY:#) (ENGRAVE)");
        }
        this.player = scriptEntry.getPlayer();
        this.giveType = null;
        this.theAmount = 1;
        this.theItem = null;
        this.engrave = false;
        for (String thisArg : scriptEntry.getArguments()) {
            if (aH.matchesQuantity(thisArg)) {
                this.theAmount = aH.getIntegerFrom(thisArg);
                dB.echoDebug("...set quantity to '%s'.", thisArg);
                continue;
            }
            if (aH.matchesArg("MONEY", thisArg)) {
                this.giveType = GiveType.MONEY;
                dB.echoDebug("...giving MONEY.");
                continue;
            }
            if (aH.matchesArg("XP", thisArg) || aH.matchesArg("EXP", thisArg)) {
                this.giveType = GiveType.EXP;
                dB.echoDebug("...giving EXP.");
                continue;
            }
            if (aH.matchesArg("ENGRAVE", thisArg)) {
                this.engrave = true;
                dB.echoDebug("...item will be engraved.");
                continue;
            }
            if (aH.matchesItem(thisArg) || aH.matchesItem("item:" + thisArg)) {
                this.theItem = aH.getItemFrom(thisArg);
                this.giveType = GiveType.ITEM;
                if (this.theItem == null) continue;
                dB.echoDebug("...set item to be given to '%s'.", thisArg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, thisArg);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dB.echoDebug("execute (" + scriptEntry.toString() + ")");
        if (this.giveType != null) {
            switch (this.giveType) {
                case MONEY: {
                    if (Depends.economy != null) {
                        double doubleAmount = this.theAmount;
                        dB.echoDebug("Giving player " + this.theAmount + " money.");
                        Depends.economy.depositPlayer(this.player.getName(), doubleAmount);
                        break;
                    }
                    dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                    break;
                }
                case EXP: {
                    this.player.giveExp(this.theAmount);
                    dB.echoDebug("..giving player " + this.theAmount + " EXP");
                    break;
                }
                case ITEM: {
                    this.theItem.setAmount(this.theAmount);
                    if (this.engrave) {
                        dB.echoDebug("...engraving " + this.theItem + " to the player");
                        NBTItem.addCustomNBT(this.theItem, "owner", this.player.getName());
                    }
                    dB.echoDebug("..giving player " + this.theAmount + " of " + this.theItem);
                    HashMap leftovers = this.player.getInventory().addItem(new ItemStack[]{this.theItem});
                    if (leftovers.isEmpty()) break;
                    dB.echoDebug("...Player did not have enough space in their inventory, the rest of the items have been placed on the floor.");
                    for (Map.Entry leftoverItem : leftovers.entrySet()) {
                        this.player.getWorld().dropItem(this.player.getLocation(), (ItemStack)leftoverItem.getValue());
                    }
                    break;
                }
            }
        }
    }
}

