/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.inventory.ItemStack;

public class EquipCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        EquipType equipType = EquipType.HAND;
        Item item = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesItem(arg)) {
                item = aH.getItemFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_ITEM, arg);
                continue;
            }
            if (!aH.matchesArg("ITEMINHAND, HAND, HOLDING", arg)) continue;
            try {
                equipType = EquipType.valueOf(arg);
                dB.echoDebug("... equiping to " + equipType.name());
            }
            catch (Exception e) {
                throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
            }
        }
        if (item == null) {
            dB.echoError("...no item specified to equip!");
        }
        scriptEntry.addObject("item", item).addObject("equipType", (Object)equipType);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        EquipType equipType = (EquipType)((Object)scriptEntry.getObject("equipType"));
        Item item = (Item)scriptEntry.getObject("item");
        NPC npc = scriptEntry.getNPC().getCitizen();
        if (!npc.hasTrait(Equipment.class)) {
            npc.addTrait(Equipment.class);
        }
        Equipment trait = (Equipment)npc.getTrait(Equipment.class);
        switch (equipType) {
            case BOOTS: {
                trait.set(4, (ItemStack)item);
                dB.echoDebug("..." + item.getType() + " equipped to BOOTS");
                break;
            }
            case CHEST: {
                trait.set(2, (ItemStack)item);
                dB.echoDebug("..." + item.getType() + " equipped to CHEST");
                break;
            }
            case HAND: {
                trait.set(0, (ItemStack)item);
                dB.echoDebug("..." + item.getType() + " equipped to HAND");
                break;
            }
            case HEAD: {
                trait.set(1, (ItemStack)item);
                dB.echoDebug("..." + item.getType() + " equipped to HEAD");
                break;
            }
            case LEGS: {
                trait.set(3, (ItemStack)item);
                dB.echoDebug("..." + item.getType() + " equipped to LEGS");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EquipType {
        HAND,
        BOOTS,
        LEGS,
        CHEST,
        HEAD;

    }
}

