/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.interfaces.dScriptArgument;
import net.aufdemrand.denizen.tags.Attribute;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Element;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.Player;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;

public class Entity
implements dScriptArgument {
    public static Map<String, Entity> entities = new HashMap<String, Entity>();
    private String id = null;
    private String prefix = "Entity";
    private LivingEntity entity;

    public static Entity getSavedEntity(String id) {
        if (entities.containsKey(id.toUpperCase())) {
            return entities.get(id.toUpperCase());
        }
        return null;
    }

    public static void saveEntity(Entity entity) {
        if (entity.id == null) {
            return;
        }
        entities.put(entity.id.toUpperCase(), entity);
    }

    public static boolean isSavedEntity(String id) {
        return entities.containsKey(id.toUpperCase());
    }

    public static void _recallEntities() {
        List entitylist = DenizenAPI.getCurrentInstance().getSaves().getMapList("dScript.Entities");
        entities.clear();
    }

    public static void _saveEntities() {
    }

    public static Entity valueOf(String string) {
        return null;
    }

    public Entity(LivingEntity entity) {
        this.entity = entity;
    }

    public Entity(String id, LivingEntity entity) {
        this.entity = entity;
        this.id = id;
        Entity.saveEntity(this);
    }

    public void identifyAs(String id) {
        if (this.id == null) {
            this.id = id;
            Entity.saveEntity(this);
        }
    }

    public LivingEntity getBukkitEntity() {
        return this.entity;
    }

    public boolean isAlive() {
        return this.entity != null;
    }

    public Entity setId(String id) {
        this.id = id.toUpperCase();
        return this;
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return null;
    }

    public String as_dScriptArg() {
        return null;
    }

    public String dScriptArgValue() {
        return this.getDefaultPrefix().toLowerCase() + ":" + this.as_dScriptArg();
    }

    public String toString() {
        return this.entity.getUniqueId().toString();
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public LivingEntity getEntity(String string) {
        return this.entity;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String id = this.id.toLowerCase();
        if (attribute.startsWith("name")) {
            return new Element(this.entity.getCustomName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location.cursor_on")) {
            int range = attribute.getIntContext(2);
            if (range < 1) {
                range = 50;
            }
            return new Location(this.entity.getTargetBlock(null, range).getLocation()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location.standing_on")) {
            return new Location(this.entity.getLocation().add(0.0, -1.0, 0.0)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location")) {
            return new Location(this.entity.getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health.formatted")) {
            int maxHealth = this.entity.getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            if ((double)((float)this.entity.getHealth() / (float)maxHealth) < 0.1) {
                return new Element("dying").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.entity.getHealth() / (float)maxHealth) < 0.4) {
                return new Element("seriously wounded").getAttribute(attribute.fulfill(2));
            }
            if ((double)((float)this.entity.getHealth() / (float)maxHealth) < 0.75) {
                return new Element("injured").getAttribute(attribute.fulfill(2));
            }
            if ((float)this.entity.getHealth() / (float)maxHealth < 1.0f) {
                return new Element("scraped").getAttribute(attribute.fulfill(2));
            }
            return new Element("healthy").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.percentage")) {
            int maxHealth = this.entity.getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            return new Element(String.valueOf((float)this.entity.getHealth() / (float)maxHealth * 100.0f)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health")) {
            return new Element(String.valueOf(this.entity.getHealth())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_inside_vehicle")) {
            return new Element(String.valueOf(this.entity.isInsideVehicle())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("killer")) {
            return new Player((OfflinePlayer)this.entity.getKiller()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_damage_cause")) {
            return new Element(String.valueOf(this.entity.getLastDamageCause().getCause().toString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_damage")) {
            return new Element(String.valueOf(this.entity.getLastDamage())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time_lived")) {
            return new Duration(this.entity.getTicksLived() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_pickup_items")) {
            return new Element(String.valueOf(this.entity.getCanPickupItems())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entity_id")) {
            return new Element(String.valueOf(this.entity.getEntityId())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fall_distance")) {
            return new Element(String.valueOf(this.entity.getFallDistance())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("uuid")) {
            return new Element(String.valueOf(this.entity.getUniqueId().toString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_effect")) {
            // empty if block
        }
        if (attribute.startsWith("equipment")) {
            // empty if block
        }
        if (attribute.startsWith("world")) {
            // empty if block
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        return this.dScriptArgValue();
    }
}

