/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;

public class DropCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Item item = null;
        Integer qty = null;
        Location location = null;
        Boolean exp = false;
        if (scriptEntry.getPlayer() != null) {
            location = new Location(scriptEntry.getPlayer().getLocation());
        }
        if (location == null && scriptEntry.getNPC() != null) {
            location = new Location(scriptEntry.getNPC().getLocation());
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesItem(arg)) {
                item = aH.getItemFrom(arg);
                continue;
            }
            if (aH.matchesArg("XP, EXP", arg)) {
                exp = true;
                continue;
            }
            if (aH.matchesQuantity(arg)) {
                qty = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (item == null && !exp.booleanValue()) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_INVALID_ITEM);
        }
        if (location == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_LOCATION);
        }
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("item", item);
        scriptEntry.addObject("exp", exp);
        scriptEntry.addObject("qty", qty);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location location = (Location)scriptEntry.getObject("location");
        Integer qty = (Integer)scriptEntry.getObject("qty");
        Boolean exp = (Boolean)scriptEntry.getObject("exp");
        Item item = (Item)scriptEntry.getObject("item");
        if (qty != null && item != null) {
            item.getItemStack().setAmount(qty.intValue());
        } else {
            qty = 1;
        }
        dB.report(this.getName(), location.debug() + (item != null ? item.debug() : aH.debugObj("Exp", String.valueOf(qty))));
        if (exp.booleanValue()) {
            ((ExperienceOrb)location.getWorld().spawnEntity((org.bukkit.Location)location, EntityType.EXPERIENCE_ORB)).setExperience(qty.intValue());
        } else {
            location.getWorld().dropItemNaturally((org.bukkit.Location)location, item.getItemStack());
        }
    }
}

