/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.Map;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class DamageTrigger
extends AbstractTrigger
implements Listener {
    @EventHandler
    public void damageTrigger(EntityDamageByEntityEvent event) {
        Player player = null;
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
        } else if (event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof Player) {
            player = (Player)((Projectile)event.getDamager()).getShooter();
        }
        if (CitizensAPI.getNPCRegistry().isNPC(event.getEntity()) && player != null) {
            Map<String, String> idMap;
            dNPC npc = DenizenAPI.getDenizenNPC(CitizensAPI.getNPCRegistry().getNPC(event.getEntity()));
            if (!npc.getCitizen().hasTrait(TriggerTrait.class)) {
                return;
            }
            if (!npc.getTriggerTrait().isEnabled(this.name)) {
                return;
            }
            if (!npc.getTriggerTrait().trigger(this, player)) {
                return;
            }
            InteractScriptContainer script = InteractScriptHelper.getInteractScript(npc, player, this.getClass());
            String id = null;
            if (script != null && !(idMap = script.getIdMapFor(this.getClass(), player)).isEmpty()) {
                for (Map.Entry<String, String> entry : idMap.entrySet()) {
                    String entry_value = TagManager.tag((OfflinePlayer)player, npc, entry.getValue());
                    if (Item.valueOf(entry_value).comparesTo(player.getItemInHand()) < 0 || !script.checkSpecificTriggerScriptRequirementsFor(this.getClass(), player, npc, entry.getKey())) continue;
                    id = entry.getKey();
                }
            }
            if (!this.parse(npc, player, script, id)) {
                npc.action("no damage trigger", player);
            }
        }
    }

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }
}

