/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.Map;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ClickTrigger
extends AbstractTrigger
implements Listener {
    @EventHandler
    public void clickTrigger(NPCRightClickEvent event) {
        Map<String, String> idMap;
        if (!event.getNPC().hasTrait(TriggerTrait.class)) {
            return;
        }
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (!npc.getTriggerTrait().isEnabled(this.name)) {
            return;
        }
        if (!npc.getTriggerTrait().trigger(this, event.getClicker())) {
            return;
        }
        Player player = event.getClicker();
        InteractScriptContainer script = npc.getInteractScript(player, this.getClass());
        String id = null;
        if (script != null && !(idMap = script.getIdMapFor(this.getClass(), player)).isEmpty()) {
            for (Map.Entry<String, String> entry : idMap.entrySet()) {
                String entry_value = TagManager.tag((OfflinePlayer)player, npc, entry.getValue());
                if (Item.valueOf(entry_value).comparesTo(player.getItemInHand()) < 0 || !script.checkSpecificTriggerScriptRequirementsFor(this.getClass(), player, npc, entry.getKey())) continue;
                id = entry.getKey();
            }
        }
        if (!this.parse(npc, player, script, id)) {
            npc.action("no click trigger", player);
        }
    }

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }
}

