/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.scoreboard;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.utilities.scoreboard.Format;
import net.aufdemrand.denizen.utilities.scoreboard.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreboardAPI {
    public static ScoreboardAPI api_instance = null;
    public static List<Scoreboard> scoreboards = new ArrayList<Scoreboard>();
    Format format = new Format(this);

    public List<Scoreboard> getScoreboards() {
        return scoreboards;
    }

    public static ScoreboardAPI getInstance() {
        return api_instance;
    }

    public Scoreboard createScoreboard(String name, int priority) {
        for (Scoreboard s : scoreboards) {
            if (s.getName() != name) continue;
            return null;
        }
        Scoreboard s = new Scoreboard(name, priority);
        scoreboards.add(s);
        return s;
    }

    public ScoreboardAPI() {
        api_instance = this;
    }

    public Scoreboard getScoreboard(String name) {
        for (Scoreboard s : scoreboards) {
            if (s.getName() != name) continue;
            return s;
        }
        return null;
    }

    public void updateForPlayer(Player p) {
        for (Scoreboard s : scoreboards) {
            s.checkIfNeedsToBeDisabledForPlayer(p);
            s.checkIfNeedsToBeEnabledForPlayer(p);
        }
    }

    public boolean isPlayerReceivingScoreboard(Player p) {
        for (Scoreboard s : scoreboards) {
            if (!s.hasPlayerAdded(p)) continue;
            return true;
        }
        return false;
    }

    public void updateForAllPlayers() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.updateForPlayer(p);
        }
    }
}

