/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import java.util.List;
import java.util.Random;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.listeners.core.ItemDropListenerType;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.WorldGuardUtilities;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDropListenerInstance
extends AbstractListener
implements Listener {
    ItemDropListenerType.ItemDropType type = null;
    ItemStack item = null;
    Location location = null;
    Material block = null;
    EntityType mob = null;
    String dropper = null;
    String region = null;
    Integer radius = 5;
    Integer dropRate = 100;
    Integer quantity = 1;
    Integer qtyDropped = 0;
    Random r = new Random();

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @Override
    public void deconstructed() {
        EntityDeathEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public void onBuild(List<String> args) {
        for (String arg : args) {
            if (aH.matchesValueArg("TYPE", arg, aH.ArgumentType.Custom)) {
                try {
                    this.type = ItemDropListenerType.ItemDropType.valueOf(aH.getStringFrom(arg));
                    dB.echoDebug("...type set to: " + this.type.name());
                }
                catch (Exception e) {
                    dB.echoDebug("...type " + this.type.name() + " is not valid.");
                }
                continue;
            }
            if (aH.matchesItem(arg)) {
                this.item = aH.getItemFrom(arg).getItemStack();
                dB.echoDebug("...item set to: " + this.item);
                continue;
            }
            if (aH.matchesValueArg("REGION", arg, aH.ArgumentType.Custom)) {
                this.region = aH.getStringFrom(arg);
                dB.echoDebug("...region set to: " + this.region);
                continue;
            }
            if (aH.matchesLocation(arg)) {
                this.location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set to: " + this.location);
                continue;
            }
            if (aH.matchesValueArg("RADIUS", arg, aH.ArgumentType.Integer)) {
                this.radius = aH.getIntegerFrom(arg);
                dB.echoDebug("...radius set to: " + this.radius);
                continue;
            }
            if (aH.matchesValueArg("DROPRATE", arg, aH.ArgumentType.Integer)) {
                this.dropRate = aH.getIntegerFrom(arg);
                dB.echoDebug("...drop rate set to: " + this.dropRate + "/100");
                continue;
            }
            if (aH.matchesValueArg("DROPSFROM", arg, aH.ArgumentType.Custom)) {
                this.dropper = aH.getStringFrom(arg);
                dB.echoDebug("...dropper set to: " + this.dropper);
                continue;
            }
            if (!aH.matchesQuantity(arg)) continue;
            this.quantity = aH.getIntegerFrom(arg);
            dB.echoDebug("...quantity set to: " + this.quantity);
        }
        if (this.item == null) {
            dB.echoDebug("...item could not be set");
            this.cancel();
        }
        switch (this.type) {
            case BLOCKPLACE: 
            case BLOCKBREAK: {
                try {
                    this.block = Material.valueOf((String)this.dropper);
                    dB.echoDebug("...DROPSFROM material set");
                }
                catch (Exception e) {
                    dB.echoDebug("...DROPSFROM is not a valid material");
                }
                break;
            }
            case MOBKILL: {
                if (aH.matchesEntityType("entity:" + this.dropper)) {
                    this.mob = EntityType.valueOf((String)this.dropper.toUpperCase());
                    dB.echoDebug("...mob selected from DROPSFROM");
                    break;
                }
                dB.echoDebug("...could not select mob from DROPSFROM");
                break;
            }
            default: {
                dB.echoDebug("...error setting type");
                this.cancel();
            }
        }
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onLoad() {
        this.type = ItemDropListenerType.ItemDropType.valueOf((String)this.get("type"));
        this.item = (ItemStack)this.get("item");
        this.location = (Location)this.get("location");
        this.block = (Material)this.get("block");
        this.mob = (EntityType)this.get("mob");
        this.dropper = (String)this.get("dropper");
        this.region = (String)this.get("region");
        this.radius = (Integer)this.get("radius");
        this.dropRate = (Integer)this.get("dropRate");
        this.quantity = (Integer)this.get("quantity");
        this.qtyDropped = (Integer)this.get("qtyDropped");
        this.r = (Random)this.get("r");
    }

    @Override
    public void onSave() {
        this.store("type", (Object)this.type);
        this.store("item", this.item);
        this.store("lcoation", this.location);
        this.store("block", this.block);
        this.store("mob", this.mob);
        this.store("dropper", this.dropper);
        this.store("region", this.region);
        this.store("radius", this.radius);
        this.store("dropRate", this.dropRate);
        this.store("quantity", this.quantity);
        this.store("qtyDropped", this.qtyDropped);
        this.store("r", this.r);
    }

    @Override
    public String report() {
        switch (this.type) {
            case BLOCKBREAK: {
                break;
            }
            case BLOCKPLACE: {
                break;
            }
            case MOBKILL: {
                break;
            }
        }
        return null;
    }

    @EventHandler
    public void mobKilled(EntityDeathEvent event) {
        if (this.type != ItemDropListenerType.ItemDropType.MOBKILL) {
            return;
        }
        dB.echoDebug("...checking kill");
        if (event.getEntity().getKiller() != this.player) {
            return;
        }
        dB.echoDebug("...killed by player");
        if (event.getEntity().getType() != this.mob) {
            return;
        }
        dB.echoDebug("...proper mob");
        if (this.location != null && this.location.distance(this.player.getLocation()) > (double)this.radius.intValue()) {
            return;
        }
        dB.echoDebug("...within range");
        if (this.region != null && !WorldGuardUtilities.checkPlayerWGRegion(this.player, this.region)) {
            return;
        }
        dB.echoDebug("...within region");
        dB.echoDebug("...trying to drop item");
        if (this.r.nextInt(101) < this.dropRate) {
            dB.echoDebug("...item should drop now");
            event.getEntity().getWorld().dropItem(event.getEntity().getLocation(), this.item);
            Integer n = this.qtyDropped;
            Integer n2 = this.qtyDropped = Integer.valueOf(this.qtyDropped + 1);
            dB.echoDebug("...item dropped");
            this.check();
        }
    }

    @EventHandler
    public void blockMined(BlockBreakEvent event) {
        if (this.type != ItemDropListenerType.ItemDropType.BLOCKBREAK) {
            return;
        }
        dB.echoDebug("...checking blockbreakevent");
        if (event.getPlayer() != this.player) {
            return;
        }
        dB.echoDebug("...mined by player");
        if (event.getBlock().getType() != this.block) {
            return;
        }
        dB.echoDebug("...proper block mined");
        if (this.location != null && this.location.distance(this.player.getLocation()) > (double)this.radius.intValue()) {
            return;
        }
        dB.echoDebug("...within range");
        if (this.region != null && !WorldGuardUtilities.checkPlayerWGRegion(this.player, this.region)) {
            return;
        }
        dB.echoDebug("...within region");
        if (this.r.nextInt(101) < this.dropRate) {
            event.getBlock().getWorld().dropItem(event.getBlock().getLocation(), this.item);
            Integer n = this.qtyDropped;
            Integer n2 = this.qtyDropped = Integer.valueOf(this.qtyDropped + 1);
            dB.echoDebug("...item dropped");
            this.check();
        }
    }

    @EventHandler
    public void blockPlaced(BlockPlaceEvent event) {
        if (this.type != ItemDropListenerType.ItemDropType.BLOCKPLACE) {
            return;
        }
        dB.echoDebug("...checking blockplaceevent");
        if (event.getPlayer() != this.player) {
            return;
        }
        dB.echoDebug("...placed by player");
        if (event.getBlock().getType() != this.block) {
            return;
        }
        dB.echoDebug("...proper block placed");
        if (this.location != null && this.location.distance(this.player.getLocation()) > (double)this.radius.intValue()) {
            return;
        }
        dB.echoDebug("...within range");
        if (this.region != null && !WorldGuardUtilities.checkPlayerWGRegion(this.player, this.region)) {
            return;
        }
        dB.echoDebug("...within region");
        if (this.r.nextInt(101) < this.dropRate) {
            event.getBlock().getWorld().dropItem(event.getBlock().getLocation(), this.item);
            Integer n = this.qtyDropped;
            Integer n2 = this.qtyDropped = Integer.valueOf(this.qtyDropped + 1);
            dB.echoDebug("...item dropped");
            this.check();
        }
    }

    private void check() {
        dB.echoDebug(this.qtyDropped + "/" + this.quantity + " dropped");
        if (this.quantity == this.qtyDropped) {
            this.finish();
        }
    }
}

