/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands;

import java.util.ArrayList;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ScriptEntryExecuteEvent;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CommandExecuter {
    private Denizen plugin;

    public CommandExecuter(Denizen denizen) {
        this.plugin = denizen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public boolean execute(ScriptEntry scriptEntry) {
        block42: {
            if (this.plugin.getCommandRegistry().get(scriptEntry.getCommandName()) == null) {
                dB.echoDebug(dB.DebugElement.Header, "Executing command: " + scriptEntry.getCommandName());
                dB.echoError(scriptEntry.getCommandName() + " is an invalid dScript command! Are you sure the command loaded?");
                dB.echoDebug(dB.DebugElement.Footer);
                return false;
            }
            AbstractCommand command = this.plugin.getCommandRegistry().get(scriptEntry.getCommandName());
            if (scriptEntry.getPlayer() != null) {
                dB.echoDebug(dB.DebugElement.Header, "Executing command: " + scriptEntry.getCommandName() + "/" + scriptEntry.getPlayer().getName());
            } else {
                dB.echoDebug(dB.DebugElement.Header, "Executing command: " + scriptEntry.getCommandName() + (scriptEntry.getNPC() != null ? "/" + scriptEntry.getNPC().getName() : ""));
            }
            boolean keepGoing = true;
            if (command.getOptions().REQUIRED_ARGS > scriptEntry.getArguments().size()) {
                throw new InvalidArgumentsException("");
            }
            if (scriptEntry.has_tags) {
                this.plugin.tagManager();
                scriptEntry.setArguments(TagManager.fillArguments(scriptEntry.getArguments(), scriptEntry, true));
                ArrayList<String> newArgs = new ArrayList<String>();
                for (String arg : scriptEntry.getArguments()) {
                    String[] split = arg.split(":");
                    if (aH.matchesValueArg("PLAYER", arg, aH.ArgumentType.String)) {
                        boolean foundNewPlayer = false;
                        dB.echoDebug("...replacing the linked Player.");
                        for (Player playa : Bukkit.getServer().getOnlinePlayers()) {
                            if (!playa.getName().equalsIgnoreCase(split[1])) continue;
                            foundNewPlayer = true;
                            scriptEntry.setPlayer(playa);
                        }
                        if (foundNewPlayer) {
                            dB.echoDebug("...player set to '%s'.", split[1]);
                        } else {
                            dB.echoDebug("This player is not online! Searching for offline player...");
                            for (Player playa : Bukkit.getServer().getOfflinePlayers()) {
                                if (!playa.getName().equalsIgnoreCase(split[1])) continue;
                                scriptEntry.setPlayer(null);
                                scriptEntry.setOfflinePlayer((OfflinePlayer)playa);
                                foundNewPlayer = true;
                            }
                        }
                        if (foundNewPlayer) {
                            dB.echoDebug("Found an offline player.. linking.");
                            continue;
                        }
                        dB.echoError("Could not find a valid player!");
                        scriptEntry.setPlayer(null);
                        continue;
                    }
                    if (aH.matchesValueArg("NPCID", arg, aH.ArgumentType.String)) {
                        dB.echoDebug("...replacing the linked NPCID.");
                        try {
                            if (CitizensAPI.getNPCRegistry().getById(Integer.valueOf(split[1]).intValue()) != null) {
                                scriptEntry.setNPC(this.plugin.getNPCRegistry().getDenizen(CitizensAPI.getNPCRegistry().getById(Integer.valueOf(split[1]).intValue())));
                            }
                            dB.echoDebug("...NPC set to '%s'.", split[1]);
                        }
                        catch (Exception e) {
                            dB.echoError("NPCID specified could not be matched to an NPC!");
                            scriptEntry.setNPC(null);
                        }
                        continue;
                    }
                    newArgs.add(arg);
                }
                scriptEntry.setArguments(newArgs);
                this.plugin.tagManager();
                scriptEntry.setArguments(TagManager.fillArguments(scriptEntry.getArguments(), scriptEntry, false));
                dB.echoDebug(ChatColor.AQUA + "+> " + ChatColor.DARK_GRAY + "Filled tags: " + scriptEntry.getArguments().toString());
            }
            command.parseArgs(scriptEntry);
            Object var14_16 = null;
            if (!keepGoing) break block42;
            try {
                ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isAltered()) {
                    scriptEntry = event.getScriptEntry();
                }
                if (!event.isCancelled()) {
                    command.execute(scriptEntry);
                    break block42;
                }
                dB.echoDebug("ScriptEntry has been cancelled.");
            }
            catch (Exception e2) {
                dB.echoError("Woah!! An exception has been called with this command!");
                if (!dB.showStackTraces) {
                    dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                    break block42;
                }
                e2.printStackTrace();
            }
            break block42;
            {
                catch (InvalidArgumentsException e) {
                    keepGoing = false;
                    dB.echoError("Woah! Invalid arguments were specified!");
                    dB.echoDebug(ChatColor.YELLOW + "+> MESSAGE follows: " + ChatColor.WHITE + "'" + e.getMessage() + "'");
                    dB.echoDebug("Usage: " + command.getUsageHint());
                    dB.echoDebug(dB.DebugElement.Footer);
                    Object var14_17 = null;
                    if (!keepGoing) break block42;
                    try {
                        ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry);
                        Bukkit.getServer().getPluginManager().callEvent((Event)event);
                        if (event.isAltered()) {
                            scriptEntry = event.getScriptEntry();
                        }
                        if (!event.isCancelled()) {
                            command.execute(scriptEntry);
                            break block42;
                        }
                        dB.echoDebug("ScriptEntry has been cancelled.");
                    }
                    catch (Exception e2) {
                        dB.echoError("Woah!! An exception has been called with this command!");
                        if (!dB.showStackTraces) {
                            dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                            break block42;
                        }
                        e2.printStackTrace();
                    }
                    break block42;
                }
                catch (Exception e) {
                    keepGoing = false;
                    dB.echoError("Woah! An exception has been called with this command!");
                    if (!dB.showStackTraces) {
                        dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                    } else {
                        e.printStackTrace();
                    }
                    dB.echoDebug(dB.DebugElement.Footer);
                    Object var14_18 = null;
                    if (!keepGoing) break block42;
                    try {
                        ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry);
                        Bukkit.getServer().getPluginManager().callEvent((Event)event);
                        if (event.isAltered()) {
                            scriptEntry = event.getScriptEntry();
                        }
                        if (!event.isCancelled()) {
                            command.execute(scriptEntry);
                            break block42;
                        }
                        dB.echoDebug("ScriptEntry has been cancelled.");
                    }
                    catch (Exception e2) {
                        dB.echoError("Woah!! An exception has been called with this command!");
                        if (!dB.showStackTraces) {
                            dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                            break block42;
                        }
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                block43: {
                    Object var14_19 = null;
                    if (keepGoing) {
                        try {
                            ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry);
                            Bukkit.getServer().getPluginManager().callEvent((Event)event);
                            if (event.isAltered()) {
                                scriptEntry = event.getScriptEntry();
                            }
                            if (!event.isCancelled()) {
                                command.execute(scriptEntry);
                            } else {
                                dB.echoDebug("ScriptEntry has been cancelled.");
                            }
                        }
                        catch (Exception e2) {
                            dB.echoError("Woah!! An exception has been called with this command!");
                            if (!dB.showStackTraces) {
                                dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                                break block43;
                            }
                            e2.printStackTrace();
                        }
                    }
                }
                throw throwable;
            }
        }
        return true;
    }
}

