/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.CommonRegistries;
import com.denizenscript.denizen.DenizenCommandHandler;
import com.denizenscript.denizen.DenizenCoreImplementation;
import com.denizenscript.denizen.NPCCommandHandler;
import com.denizenscript.denizen.Settings;
import com.denizenscript.denizen.events.ScriptEventRegistry;
import com.denizenscript.denizen.events.bukkit.SavesReloadEvent;
import com.denizenscript.denizen.events.core.CommandSmartEvent;
import com.denizenscript.denizen.events.core.CuboidEnterExitSmartEvent;
import com.denizenscript.denizen.events.core.FlagSmartEvent;
import com.denizenscript.denizen.events.core.NPCNavigationSmartEvent;
import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.FakeArrow;
import com.denizenscript.denizen.nms.interfaces.FakePlayer;
import com.denizenscript.denizen.nms.interfaces.ItemProjectile;
import com.denizenscript.denizen.npc.DenizenNPCHelper;
import com.denizenscript.denizen.npc.TraitRegistry;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.objects.properties.PropertyRegistry;
import com.denizenscript.denizen.scripts.commands.BukkitCommandRegistry;
import com.denizenscript.denizen.scripts.containers.ContainerRegistry;
import com.denizenscript.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.scripts.triggers.TriggerRegistry;
import com.denizenscript.denizen.tags.core.ServerTagBase;
import com.denizenscript.denizen.utilities.BStatsMetricsLite;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.OldMaterialsHelper;
import com.denizenscript.denizen.utilities.command.CommandManager;
import com.denizenscript.denizen.utilities.command.Injector;
import com.denizenscript.denizen.utilities.command.messaging.Messaging;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.debugging.StatsRecord;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.maps.DenizenMapManager;
import com.denizenscript.denizen.utilities.packets.DenizenPacketHandler;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.core.AdjustCommand;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.text.ConfigUpdater;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Denizen
extends JavaPlugin {
    public static String versionTag = null;
    private boolean startedSuccessful = false;
    private CommandManager commandManager;
    private BukkitCommandRegistry commandRegistry = new BukkitCommandRegistry();
    private TriggerRegistry triggerRegistry = new TriggerRegistry();
    private DenizenNPCHelper npcHelper;
    private FlagManager flagManager = new FlagManager(this);
    private TagManager tagManager = new TagManager();
    private NotableManager notableManager = new NotableManager();
    private OldEventManager eventManager;
    private BukkitWorldScriptHelper ws_helper;
    public static final long startTime = System.currentTimeMillis();
    public DenizenCoreImplementation coreImplementation = new DenizenCoreImplementation();
    private FileConfiguration savesConfig = null;
    private File savesConfigFile = null;
    private FileConfiguration scoreboardsConfig = null;
    private File scoreboardsConfigFile = null;
    private FileConfiguration entityConfig = null;
    private File entityConfigFile = null;

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public BukkitCommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public DenizenNPCHelper getNPCHelper() {
        return this.npcHelper;
    }

    public TriggerRegistry getTriggerRegistry() {
        return this.triggerRegistry;
    }

    public OldEventManager eventManager() {
        return this.eventManager;
    }

    public FlagManager flagManager() {
        return this.flagManager;
    }

    public TagManager tagManager() {
        return this.tagManager;
    }

    public NotableManager notableManager() {
        return this.notableManager;
    }

    public void onEnable() {
        if (!NMSHandler.initialize(this)) {
            this.getLogger().warning("-------------------------------------");
            this.getLogger().warning("This build of Denizen is not compatible with this Spigot version! Deactivating Denizen!");
            this.getLogger().warning("-------------------------------------");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.startedSuccessful = false;
            return;
        }
        if (!NMSHandler.getInstance().isCorrectMappingsCode()) {
            this.getLogger().warning("-------------------------------------");
            this.getLogger().warning("This build of Denizen was built for a different Spigot revision! This may potentially cause issues. If you are experiencing trouble, update Denizen and Spigot both to latest builds! If this message appears with both Denizen and Spigot fully up-to-date, contact the Denizen team (via GitHub, Spigot, or Discord) to request an update be built.");
            this.getLogger().warning("-------------------------------------");
        }
        try {
            versionTag = this.getDescription().getVersion();
            DenizenCore.init(this.coreImplementation);
            Depends.initialize();
            if (Depends.citizens == null || !Depends.citizens.isEnabled()) {
                this.getLogger().warning("Citizens does not seem to be activated! Denizen will have greatly reduced functionality!");
            }
            this.startedSuccessful = true;
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            this.saveDefaultConfig();
            this.reloadConfig();
            Debug.log(ChatColor.LIGHT_PURPLE + "+-------------------------+");
            Debug.log(ChatColor.YELLOW + " _/_ _  ._  _ _  ");
            Debug.log(ChatColor.YELLOW + "(/(-/ )/ /_(-/ ) " + ChatColor.GRAY + " scriptable minecraft");
            Debug.log("");
            Debug.log(ChatColor.GRAY + "by: " + ChatColor.WHITE + "The DenizenScript team");
            Debug.log(ChatColor.GRAY + "Chat with us at: " + ChatColor.WHITE + " https://discord.gg/Q6pZGSR");
            Debug.log(ChatColor.GRAY + "Or learn more at: " + ChatColor.WHITE + " https://denizenscript.com");
            Debug.log(ChatColor.GRAY + "version: " + ChatColor.WHITE + versionTag);
            Debug.log(ChatColor.LIGHT_PURPLE + "+-------------------------+");
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            OfflinePlayer[] e = new BStatsMetricsLite((Plugin)this);
        }
        catch (Throwable e) {
            Debug.echoError(e);
        }
        try {
            if (Depends.citizens != null) {
                this.npcHelper = new DenizenNPCHelper(this);
            }
            this.commandManager = new CommandManager();
            this.commandManager.setInjector(new Injector(new Object[]{this}));
            this.commandManager.register(DenizenCommandHandler.class);
            if (Depends.citizens != null) {
                Depends.citizens.registerCommandClass(NPCCommandHandler.class);
            }
            DenizenEntityType.registerEntityType("ITEM_PROJECTILE", ItemProjectile.class);
            DenizenEntityType.registerEntityType("FAKE_ARROW", FakeArrow.class);
            DenizenEntityType.registerEntityType("FAKE_PLAYER", FakePlayer.class);
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                PlayerTag.notePlayer(player);
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            DenizenCore.setCommandRegistry(this.getCommandRegistry());
            this.getCommandRegistry().registerCommands();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            ScriptRegistry._registerCoreTypes();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            ContainerRegistry.registerMainContainers();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            new File(this.getDataFolder() + "/scripts").mkdirs();
            new File(this.getDataFolder() + "/midi").mkdirs();
            new File(this.getDataFolder() + "/schematics").mkdirs();
            if (!new File(this.getDataFolder() + "/midi/Denizen.mid").exists()) {
                String sourceFile = URLDecoder.decode(Denizen.class.getProtectionDomain().getCodeSource().getLocation().getFile());
                Debug.log("Denizen.mid not found, extracting from " + sourceFile);
                Utilities.extractFile(new File(sourceFile), "Denizen.mid", this.getDataFolder() + "/midi/");
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            InputStream properConfig = Denizen.class.getResourceAsStream("/config.yml");
            String properConfigString = ScriptHelper.convertStreamToString(properConfig);
            properConfig.close();
            FileInputStream currentConfig = new FileInputStream(this.getDataFolder() + "/config.yml");
            String currentConfigString = ScriptHelper.convertStreamToString(currentConfig);
            currentConfig.close();
            String updated = ConfigUpdater.updateConfig(currentConfigString, properConfigString);
            if (updated != null) {
                Debug.log("Your config file is outdated. Automatically updating it...");
                FileOutputStream configOutput = new FileOutputStream(this.getDataFolder() + "/config.yml");
                OutputStreamWriter writer = new OutputStreamWriter(configOutput);
                writer.write(updated);
                writer.close();
                configOutput.close();
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            this.ws_helper = new BukkitWorldScriptHelper();
            ItemScriptHelper is_helper = new ItemScriptHelper();
            InventoryScriptHelper in_helper = new InventoryScriptHelper();
            EntityScriptHelper es_helper = new EntityScriptHelper();
            CommandScriptHelper commandScriptHelper = new CommandScriptHelper();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            if (Depends.citizens != null) {
                TraitRegistry.registerMainTraits();
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            if (Depends.citizens != null) {
                this.getTriggerRegistry().registerCoreMembers();
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            AdjustCommand.specialAdjustables.put("server", ServerTagBase::adjustServer);
            this.tagManager().registerCoreTags();
            CommonRegistries.registerMainTagHandlers();
            this.eventManager = new OldEventManager();
            OldEventManager.registerSmartEvent(new CommandSmartEvent());
            OldEventManager.registerSmartEvent(new CuboidEnterExitSmartEvent());
            OldEventManager.registerSmartEvent(new FlagSmartEvent());
            OldEventManager.registerSmartEvent(new NPCNavigationSmartEvent());
            this.eventManager().registerCoreMembers();
            ScriptEventRegistry.registerMainEvents();
            CommonRegistries.registerMainObjects();
            ObjectFetcher._registerCoreObjects();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            OldMaterialsHelper._initialize();
            PropertyRegistry.registermainProperties();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            for (World world : this.getServer().getWorlds()) {
                EntityScriptHelper.linkWorld(world);
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        if (Settings.packetInterception()) {
            NMSHandler.getInstance().enablePacketInterception(new DenizenPacketHandler());
        }
        try {
            if (Class.forName("com.destroystokyo.paper.PaperConfig") != null) {
                Class<?> clazz = Class.forName("com.denizenscript.denizen.paper.PaperModule");
                clazz.getMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException clazz) {
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                try {
                    DenizenCore.loadScripts();
                    CommandScriptHelper.syncDenizenCommands();
                    Denizen.this.reloadSaves();
                    Denizen.this.ws_helper.serverPreStartEvent();
                    Denizen.this.notableManager.reloadNotables();
                    Debug.log(ChatColor.LIGHT_PURPLE + "+-------------------------+");
                    Denizen.this.ws_helper.serverStartEvent();
                    if (Settings.allowStupidx()) {
                        Debug.echoError("Don't screw with bad config values.");
                        Bukkit.shutdown();
                    }
                }
                catch (Exception e) {
                    Debug.echoError(e);
                }
            }
        }, 1L);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                DenizenCore.tick(50);
            }
        }, 1L, 1L);
        new BukkitRunnable(){

            public void run() {
                if (Settings.canRecordStats()) {
                    new StatsRecord().start();
                }
            }
        }.runTaskTimer((Plugin)this, 100L, 72000L);
    }

    public void onDisable() {
        if (!this.startedSuccessful) {
            return;
        }
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        OldEventManager.doEvents(Arrays.asList("shutdown"), new BukkitScriptEntryData(null, null), context);
        this.notableManager.saveNotables();
        ScoreboardHelper._saveScoreboards();
        EntityScriptHelper.saveEntities();
        InventoryScriptHelper._savePlayerInventories();
        this.getCommandRegistry().disableCoreMembers();
        this.getLogger().log(Level.INFO, " v" + this.getDescription().getVersion() + " disabled.");
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        for (World world : this.getServer().getWorlds()) {
            EntityScriptHelper.unlinkWorld(world);
        }
        this.saveSaves();
    }

    public void reloadConfig() {
        super.reloadConfig();
        Settings.refillCache();
        if (!Settings.showDebug()) {
            this.getLogger().warning("Debug is disabled in the Denizen config. This is almost always a mistake, and should not be done in the majority of cases.");
        }
        SlowWarning.WARNING_RATE = Settings.warningRate();
    }

    public void reloadSaves() {
        if (this.savesConfigFile == null) {
            this.savesConfigFile = new File(this.getDataFolder(), "saves.yml");
        }
        this.savesConfig = YamlConfiguration.loadConfiguration((File)this.savesConfigFile);
        if (this.scoreboardsConfigFile == null) {
            this.scoreboardsConfigFile = new File(this.getDataFolder(), "scoreboards.yml");
        }
        this.scoreboardsConfig = YamlConfiguration.loadConfiguration((File)this.scoreboardsConfigFile);
        ScoreboardHelper._recallScoreboards();
        if (this.entityConfigFile == null) {
            this.entityConfigFile = new File(this.getDataFolder(), "entities.yml");
        }
        this.entityConfig = YamlConfiguration.loadConfiguration((File)this.entityConfigFile);
        EntityScriptHelper.reloadEntities();
        DenizenMapManager.reloadMaps();
        Bukkit.getServer().getPluginManager().callEvent((Event)new SavesReloadEvent());
    }

    public FileConfiguration getSaves() {
        if (this.savesConfig == null) {
            this.reloadSaves();
        }
        return this.savesConfig;
    }

    public FileConfiguration getScoreboards() {
        if (this.scoreboardsConfig == null) {
            this.reloadSaves();
        }
        return this.scoreboardsConfig;
    }

    public FileConfiguration getEntities() {
        if (this.entityConfig == null) {
            this.reloadSaves();
        }
        return this.entityConfig;
    }

    public void saveSaves() {
        if (this.savesConfig == null || this.savesConfigFile == null) {
            return;
        }
        this.notableManager.saveNotables();
        ScoreboardHelper._saveScoreboards();
        EntityScriptHelper.saveEntities();
        DenizenMapManager.saveMaps();
        try {
            this.savesConfig.save(this.savesConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.savesConfigFile, ex);
        }
        try {
            this.scoreboardsConfig.save(this.scoreboardsConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.scoreboardsConfigFile, ex);
        }
        try {
            this.entityConfig.save(this.entityConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.entityConfigFile, ex);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        String modifier;
        if (cmdName.equalsIgnoreCase("ex")) {
            ArrayList<Object> entries = new ArrayList<Object>();
            String entry = String.join((CharSequence)" ", args);
            boolean quiet = false;
            if (entry.length() > 3 && entry.startsWith("-q ")) {
                quiet = true;
                entry = entry.substring("-q ".length());
            }
            if (!Settings.showExDebug()) {
                boolean bl = quiet = !quiet;
            }
            if (entry.length() < 2) {
                sender.sendMessage("/ex (-q) <denizen script command> (arguments)");
                return true;
            }
            if (Settings.showExHelp()) {
                if (Debug.showDebug) {
                    sender.sendMessage(ChatColor.YELLOW + "Executing Denizen script command... check the console for full debug output!");
                } else {
                    sender.sendMessage(ChatColor.YELLOW + "Executing Denizen script command... to see debug, use /denizen debug");
                }
            }
            entries.add(entry);
            InstantQueue queue = new InstantQueue("EXCOMMAND");
            NPCTag npc = null;
            if (Depends.citizens != null && Depends.citizens.getNPCSelector().getSelected(sender) != null) {
                npc = new NPCTag(Depends.citizens.getNPCSelector().getSelected(sender));
            }
            List<ScriptEntry> scriptEntries = ScriptBuilder.buildScriptEntries(entries, null, new BukkitScriptEntryData(sender instanceof Player ? new PlayerTag((Player)sender) : null, npc));
            queue.addEntries(scriptEntries);
            if (!quiet && sender instanceof Player) {
                queue.debugOutput = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
            }
            queue.start();
            return true;
        }
        String string = modifier = args.length > 0 ? args[0] : "";
        if (!this.commandManager.hasCommand(cmd, modifier) && !modifier.isEmpty()) {
            return this.suggestClosestModifier(sender, cmd.getName(), modifier);
        }
        Object[] methodArgs = new Object[]{sender};
        return this.commandManager.executeSafe(cmd, args, sender, methodArgs);
    }

    private boolean suggestClosestModifier(CommandSender sender, String command, String modifier) {
        String closest = this.commandManager.getClosestCommandModifier(command, modifier);
        if (!closest.isEmpty()) {
            Messaging.send(sender, "<7>Unknown command. Did you mean:");
            Messaging.send(sender, " /" + command + " " + closest);
            return true;
        }
        return false;
    }

    public FlagManager.Flag getFlag(String string) {
        if (string.startsWith("fl")) {
            FlagManager flag_manager = DenizenAPI.getCurrentInstance().flagManager();
            if (string.indexOf(91) == 2) {
                int cb = string.indexOf(93);
                if (cb > 4) {
                    String owner = string.substring(3, cb);
                    String flag = string.substring(cb + 2);
                    if (PlayerTag.matches(owner)) {
                        PlayerTag player = PlayerTag.valueOf(owner);
                        if (FlagManager.playerHasFlag(player, flag)) {
                            return flag_manager.getPlayerFlag(player, flag);
                        }
                        Debug.echoError("Player '" + owner + "' flag '" + flag + "' not found.");
                    } else if (Depends.citizens != null && NPCTag.matches(owner)) {
                        NPCTag npc = NPCTag.valueOf(owner);
                        if (FlagManager.npcHasFlag(npc, flag)) {
                            return flag_manager.getNPCFlag(npc.getId(), flag);
                        }
                        Debug.echoError("NPC '" + owner + "' flag '" + flag + "' not found.");
                    } else if (EntityTag.matches(owner)) {
                        EntityTag entity = EntityTag.valueOf(owner);
                        if (FlagManager.entityHasFlag(entity, flag)) {
                            return flag_manager.getEntityFlag(entity, flag);
                        }
                        Debug.echoError("Entity '" + owner + "' flag '" + flag + "' not found.");
                    }
                } else {
                    Debug.echoError("Invalid dFlag format: " + string);
                }
            } else if (string.indexOf(64) == 2) {
                String flag = string.substring(3);
                if (FlagManager.serverHasFlag(flag)) {
                    return flag_manager.getGlobalFlag(flag);
                }
                Debug.echoError("Global flag '" + flag + "' not found.");
            }
        }
        return null;
    }
}

