/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageEvent;

public class PlayerDamagesBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerDamagesBlockScriptEvent instance;
    public LocationTag location;
    public MaterialTag material;
    public Boolean instabreak;
    public BlockDamageEvent event;

    public PlayerDamagesBlockScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String mat = CoreUtilities.getXthArg(2, lower);
        return lower.startsWith("player damages") && (mat.equals("block") || MaterialTag.matches(mat));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(2);
        if (!this.tryMaterial(this.material, mat)) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "PlayerDamagesBlock";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && CoreUtilities.toLowerCase(determinationObj.toString()).equals("instabreak")) {
            this.instabreak = true;
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        if (name.equals("cuboids")) {
            Debug.echoError("context.cuboids tag is deprecated in " + this.getName() + " script event");
            ListTag cuboids = new ListTag();
            for (CuboidTag cuboid : CuboidTag.getNotableCuboidsContaining(this.location)) {
                cuboids.add(cuboid.identifySimple());
            }
            return cuboids;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerDamagesBlock(BlockDamageEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.material = new MaterialTag(event.getBlock());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.instabreak = event.getInstaBreak();
        this.event = event;
        this.fire((Event)event);
        event.setInstaBreak(this.instabreak.booleanValue());
    }
}

