/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.plugin.Plugin;

public class PlayerItemTakesDamageScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerItemTakesDamageScriptEvent instance;
    PlayerItemDamageEvent event;
    ElementTag damage;
    ItemTag item;
    LocationTag location;

    public PlayerItemTakesDamageScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return (lower.startsWith("players") || lower.startsWith("player")) && CoreUtilities.getXthArg(2, lower).equals("takes") && CoreUtilities.getXthArg(3, lower).equals("damage");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String iItem = path.eventArgLowerAt(1);
        if (!this.tryItem(this.item, iItem)) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "PlayerItemTakesDamage";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.damage = (ElementTag)determinationObj;
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public BukkitScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("damage")) {
            return this.damage;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerItemTakesDamage(PlayerItemDamageEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.item = new ItemTag(event.getItem());
        this.damage = new ElementTag(event.getDamage());
        this.location = new LocationTag(event.getPlayer().getLocation());
        boolean wasCancelled = event.isCancelled();
        this.event = event;
        this.fire((Event)event);
        event.setDamage(this.damage.asInt());
        final Player p = event.getPlayer();
        if (this.cancelled && !wasCancelled) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    p.updateInventory();
                }
            }, 1L);
        }
    }
}

