/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

public class PlayerLoginScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerLoginScriptEvent instance;
    private String message;
    private Boolean kicked;
    public PlayerLoginEvent event;

    public PlayerLoginScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player") && (lower.contains("logs in") || lower.contains("login"));
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        return !CoreUtilities.toLowerCase(s).contains("first") || !PlayerTag.isNoted((OfflinePlayer)this.event.getPlayer());
    }

    @Override
    public String getName() {
        return "PlayerLogin";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination;
        if (determinationObj instanceof ElementTag && CoreUtilities.toLowerCase(determination = determinationObj.toString()).startsWith("kicked")) {
            this.message = determination.length() > 7 ? determination.substring(7) : determination;
            this.kicked = true;
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new PlayerTag(this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("hostname")) {
            return new ElementTag(this.event.getAddress().toString());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.kicked = false;
        this.event = event;
        this.fire((Event)event);
        if (this.kicked.booleanValue()) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.message);
        }
    }
}

