/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms;

import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.abstracts.AnimationHelper;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.abstracts.ParticleHelper;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.nms.interfaces.AdvancementHelper;
import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.interfaces.ChunkHelper;
import com.denizenscript.denizen.nms.interfaces.CustomEntityHelper;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.interfaces.SoundHelper;
import com.denizenscript.denizen.nms.interfaces.WorldHelper;
import com.denizenscript.denizen.nms.interfaces.packets.PacketHandler;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public abstract class NMSHandler {
    private static NMSHandler instance;
    private static NMSVersion version;
    private static JavaPlugin javaPlugin;
    public static boolean debugPackets;
    public AdvancementHelper advancementHelper;
    public AnimationHelper animationHelper;
    public BlockHelper blockHelper;
    public ChunkHelper chunkHelper;
    public CustomEntityHelper customEntityHelper;
    public EntityHelper entityHelper;
    public FishingHelper fishingHelper;
    public ItemHelper itemHelper;
    public SoundHelper soundHelper;
    public PacketHelper packetHelper;
    public ParticleHelper particleHelper;
    public PlayerHelper playerHelper;
    public WorldHelper worldHelper;
    public HashMap<UUID, UUID> attachmentsA = new HashMap();
    public HashMap<UUID, UUID> attachments2 = new HashMap();
    public HashMap<UUID, Vector> attachmentOffsets = new HashMap();
    public HashSet<UUID> attachmentRotations = new HashSet();
    public HashMap<UUID, Vector> visiblePositions = new HashMap();

    public static boolean initialize(JavaPlugin plugin) {
        javaPlugin = plugin;
        String packageName = javaPlugin.getServer().getClass().getPackage().getName();
        int indexOfSubRevision = packageName.indexOf(82);
        if (indexOfSubRevision > 0) {
            packageName = packageName.substring(0, indexOfSubRevision - 1);
        }
        try {
            version = NMSVersion.valueOf(packageName.substring(packageName.lastIndexOf(46) + 1));
        }
        catch (Exception e) {
            version = NMSVersion.NOT_SUPPORTED;
            instance = null;
            return false;
        }
        try {
            Class<?> clazz = Class.forName("com.denizenscript.denizen.nms." + version.name() + ".Handler");
            if (NMSHandler.class.isAssignableFrom(clazz)) {
                instance = (NMSHandler)clazz.newInstance();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        version = NMSVersion.NOT_SUPPORTED;
        instance = null;
        return false;
    }

    public static NMSHandler getInstance() {
        return instance;
    }

    public static NMSVersion getVersion() {
        return version;
    }

    public static JavaPlugin getJavaPlugin() {
        return javaPlugin;
    }

    public static AdvancementHelper getAdvancementHelper() {
        return NMSHandler.getInstance().advancementHelper;
    }

    public static AnimationHelper getAnimationHelper() {
        return NMSHandler.getInstance().animationHelper;
    }

    public static BlockHelper getBlockHelper() {
        return NMSHandler.getInstance().blockHelper;
    }

    public static ChunkHelper getChunkHelper() {
        return NMSHandler.getInstance().chunkHelper;
    }

    public static CustomEntityHelper getCustomEntityHelper() {
        return NMSHandler.getInstance().customEntityHelper;
    }

    public static EntityHelper getEntityHelper() {
        return NMSHandler.getInstance().entityHelper;
    }

    public static FishingHelper getFishingHelper() {
        return NMSHandler.getInstance().fishingHelper;
    }

    public static ItemHelper getItemHelper() {
        return NMSHandler.getInstance().itemHelper;
    }

    public static SoundHelper getSoundHelper() {
        return NMSHandler.getInstance().soundHelper;
    }

    public static PacketHelper getPacketHelper() {
        return NMSHandler.getInstance().packetHelper;
    }

    public static ParticleHelper getParticleHelper() {
        return NMSHandler.getInstance().particleHelper;
    }

    public static PlayerHelper getPlayerHelper() {
        return NMSHandler.getInstance().playerHelper;
    }

    public static WorldHelper getWorldHelper() {
        return NMSHandler.getInstance().worldHelper;
    }

    public boolean isCorrectMappingsCode() {
        return true;
    }

    public abstract void disableAsyncCatcher();

    public abstract void undisableAsyncCatcher();

    public abstract Sidebar createSidebar(Player var1);

    public abstract BlockLight createBlockLight(Location var1, int var2, long var3);

    public abstract PlayerProfile fillPlayerProfile(PlayerProfile var1);

    public abstract PlayerProfile getPlayerProfile(Player var1);

    public abstract ProfileEditor getProfileEditor();

    public abstract BiomeNMS getBiomeNMS(Biome var1);

    public abstract Thread getMainThread();

    public abstract double[] getRecentTps();

    public abstract void enablePacketInterception(PacketHandler var1);

    public abstract CompoundTag createCompoundTag(Map<String, Tag> var1);

    public abstract int getPort();

    public abstract String getTitle(Inventory var1);

    public static Vector fixOffset(Vector offset, double yaw, double pitch) {
        yaw = Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        Vector offsetPatched = offset.clone();
        double cosPitch = Math.cos(pitch);
        double sinPitch = Math.sin(pitch);
        double y1 = offsetPatched.getY() * cosPitch - offsetPatched.getZ() * sinPitch;
        double z1 = offsetPatched.getY() * sinPitch + offsetPatched.getZ() * cosPitch;
        offsetPatched.setY(y1);
        offsetPatched.setZ(z1);
        double cosYaw = Math.cos(yaw);
        double sinYaw = Math.sin(yaw);
        double x2 = offsetPatched.getX() * cosYaw + offsetPatched.getZ() * sinYaw;
        double z2 = offsetPatched.getX() * -sinYaw + offsetPatched.getZ() * cosYaw;
        offsetPatched.setX(x2);
        offsetPatched.setZ(z2);
        return offsetPatched;
    }

    public void forceAttachMove(Entity a, Entity b, Vector offset, boolean matchRotation) {
        if (this.attachmentsA.containsKey(a.getUniqueId())) {
            this.attachments2.remove(this.attachmentsA.get(a.getUniqueId()));
            this.attachmentsA.remove(a.getUniqueId());
            this.attachmentOffsets.remove(a.getUniqueId());
            this.attachmentRotations.remove(a.getUniqueId());
        }
        if (b == null) {
            return;
        }
        this.attachmentsA.put(a.getUniqueId(), b.getUniqueId());
        this.attachments2.put(b.getUniqueId(), a.getUniqueId());
        this.attachmentOffsets.put(a.getUniqueId(), offset);
        if (matchRotation) {
            this.attachmentRotations.add(a.getUniqueId());
        }
    }

    static {
        debugPackets = false;
    }
}

