/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.abstracts;

import com.denizenscript.denizen.nms.NMSHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public abstract class BlockLight {
    protected static final Map<Location, BlockLight> lightsByLocation = new HashMap<Location, BlockLight>();
    protected static final Map<Chunk, List<BlockLight>> lightsByChunk = new HashMap<Chunk, List<BlockLight>>();
    protected static final BlockFace[] adjacentFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};
    public final Block block;
    public final Chunk chunk;
    public final int originalLight;
    public int currentLight;
    public int cachedLight;
    public int intendedLevel;
    public BukkitTask removeTask;
    public BukkitTask updateTask;

    protected BlockLight(Location location, long ticks) {
        this.block = location.getBlock();
        this.chunk = location.getChunk();
        this.currentLight = this.originalLight = (int)this.block.getLightFromBlocks();
        this.cachedLight = this.originalLight;
        this.intendedLevel = this.originalLight;
        this.removeLater(ticks);
    }

    public void removeLater(long ticks) {
        if (ticks > 0L) {
            this.removeTask = new BukkitRunnable(){

                public void run() {
                    BlockLight.this.removeTask = null;
                    BlockLight.removeLight(BlockLight.this.block.getLocation());
                }
            }.runTaskLater((Plugin)NMSHandler.getJavaPlugin(), ticks);
        }
    }

    public static void removeLight(Location location) {
        BlockLight blockLight = lightsByLocation.get(location = location.getBlock().getLocation());
        if (blockLight != null) {
            if (blockLight.updateTask != null) {
                blockLight.updateTask.cancel();
                blockLight.updateTask = null;
            }
            blockLight.reset(true);
            if (blockLight.removeTask != null) {
                blockLight.removeTask.cancel();
                blockLight.removeTask = null;
            }
            lightsByLocation.remove(location);
            List<BlockLight> lights = lightsByChunk.get(blockLight.chunk);
            lights.remove(blockLight);
            if (lights.isEmpty()) {
                lightsByChunk.remove(blockLight.chunk);
            }
        }
    }

    public void reset(boolean updateChunk) {
        this.update(this.originalLight, updateChunk);
    }

    public abstract void update(int var1, boolean var2);
}

