/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_14.helpers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.BoundingBox;
import com.denizenscript.denizen.nms.util.Utilities;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_14.impl.blocks.BlockDataImpl;
import com.denizenscript.denizen.nms.v1_14.impl.jnbt.CompoundTagImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.v1_14_R1.AxisAlignedBB;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityInsentient;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.EnumHand;
import net.minecraft.server.v1_14_R1.EnumMoveType;
import net.minecraft.server.v1_14_R1.GenericAttributes;
import net.minecraft.server.v1_14_R1.MovingObjectPosition;
import net.minecraft.server.v1_14_R1.MovingObjectPositionBlock;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.NavigationAbstract;
import net.minecraft.server.v1_14_R1.PathEntity;
import net.minecraft.server.v1_14_R1.PlayerChunkMap;
import net.minecraft.server.v1_14_R1.RayTrace;
import net.minecraft.server.v1_14_R1.Vec3D;
import net.minecraft.server.v1_14_R1.World;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    static final int MAX_ITERATIONS = 100000;

    @Override
    public String getArrowPickupStatus(org.bukkit.entity.Entity entity) {
        return ((Arrow)entity).getPickupStatus().name();
    }

    @Override
    public void setArrowPickupStatus(org.bukkit.entity.Entity entity, String status) {
        ((Arrow)entity).setPickupStatus(AbstractArrow.PickupStatus.valueOf((String)status));
    }

    @Override
    public double getArrowDamage(org.bukkit.entity.Entity arrow) {
        return ((Arrow)arrow).getDamage();
    }

    @Override
    public void setArrowDamage(org.bukkit.entity.Entity arrow, double damage) {
        ((Arrow)arrow).setDamage(damage);
    }

    @Override
    public void setCarriedItem(Enderman entity, ItemStack item) {
        entity.setCarriedBlock(Bukkit.createBlockData((Material)item.getType()));
    }

    @Override
    public void setRiptide(org.bukkit.entity.Entity entity, boolean state) {
        ((CraftLivingEntity)entity).getHandle().q(state ? 0 : 1);
    }

    @Override
    public int getBodyArrows(org.bukkit.entity.Entity entity) {
        return ((CraftLivingEntity)entity).getHandle().getArrowCount();
    }

    @Override
    public void setBodyArrows(org.bukkit.entity.Entity entity, int numArrows) {
        ((CraftLivingEntity)entity).getHandle().setArrowCount(numArrows);
    }

    @Override
    public org.bukkit.entity.Entity getFishHook(PlayerFishEvent event) {
        return event.getHook();
    }

    @Override
    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftBlock)location.getBlock()).getNMS().interact((World)((CraftWorld)location.getWorld()).getHandle(), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumHand.MAIN_HAND, new MovingObjectPositionBlock(new Vec3D(0.0, 0.0, 0.0), null, pos, false));
    }

    @Override
    public org.bukkit.entity.Entity getEntity(org.bukkit.World world, UUID uuid) {
        Entity entity = ((CraftWorld)world).getHandle().getEntity(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public boolean isBreeding(Animals entity) {
        return ((CraftAnimals)entity).getHandle().isInLove();
    }

    @Override
    public void setBreeding(Animals entity, boolean breeding) {
        if (breeding) {
            ((CraftAnimals)entity).getHandle().a((EntityHuman)null);
        } else {
            ((CraftAnimals)entity).getHandle().resetLove();
        }
    }

    @Override
    public void setTarget(Creature entity, LivingEntity target) {
        EntityLiving nmsTarget = target != null ? ((CraftLivingEntity)target).getHandle() : null;
        ((CraftCreature)entity).getHandle().setGoalTarget(nmsTarget, EntityTargetEvent.TargetReason.CUSTOM, true);
        entity.setTarget(target);
    }

    @Override
    public CompoundTag getNbtData(org.bukkit.entity.Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().c(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    @Override
    public void setNbtData(org.bukkit.entity.Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().f(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    @Override
    public void setSilent(org.bukkit.entity.Entity entity, boolean silent) {
        entity.setSilent(silent);
    }

    @Override
    public boolean isSilent(org.bukkit.entity.Entity entity) {
        return entity.isSilent();
    }

    @Override
    public ItemStack getItemInHand(LivingEntity entity) {
        return entity.getEquipment().getItemInMainHand();
    }

    @Override
    public void setItemInHand(LivingEntity entity, ItemStack itemStack) {
        entity.getEquipment().setItemInMainHand(itemStack);
    }

    @Override
    public ItemStack getItemInOffHand(LivingEntity entity) {
        return entity.getEquipment().getItemInOffHand();
    }

    @Override
    public void setItemInOffHand(LivingEntity entity, ItemStack itemStack) {
        entity.getEquipment().setItemInOffHand(itemStack);
    }

    @Override
    public void stopFollowing(org.bukkit.entity.Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    @Override
    public void stopWalking(org.bukkit.entity.Entity entity) {
        Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).getNavigation().o();
    }

    @Override
    public void toggleAI(org.bukkit.entity.Entity entity, boolean hasAI) {
        Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).setNoAI(!hasAI);
    }

    @Override
    public boolean isAIDisabled(org.bukkit.entity.Entity entity) {
        Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return true;
        }
        return ((EntityInsentient)nmsEntity).isNoAI();
    }

    @Override
    public double getSpeed(org.bukkit.entity.Entity entity) {
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return 0.0;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        return nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).getBaseValue();
    }

    @Override
    public void setSpeed(org.bukkit.entity.Entity entity, double speed) {
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
    }

    @Override
    public void follow(final org.bukkit.entity.Entity target, final org.bukkit.entity.Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander) {
        if (target == null || follower == null) {
            return;
        }
        Entity nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.getNavigation();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation(targetLocation, follower.getLocation(), maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        follower.teleport(Utilities.getWalkableLocationNear(targetLocation, locationNearInt));
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 100000);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation(targetLocation, follower.getLocation(), lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 100000);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.o();
                }
                nmsFollower.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    @Override
    public void walkTo(final org.bukkit.entity.Entity entity, Location location, double speed, final Runnable callback) {
        PathEntity path;
        if (entity == null || location == null) {
            return;
        }
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        final NavigationAbstract entityNavigation = nmsEntity.getNavigation();
        final boolean aiDisabled = this.isAIDisabled(entity);
        if (aiDisabled) {
            this.toggleAI(entity, true);
            nmsEntity.onGround = true;
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 100000)) != null) {
            entityNavigation.a(path, 1.0);
            entityNavigation.a(2.0);
            final double oldSpeed = nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).getBaseValue();
            nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        ((Wolf)entity).setAngry(false);
                    }
                    if (entityNavigation.n() || path.b()) {
                        if (callback != null) {
                            callback.run();
                        }
                        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(oldSpeed);
                        if (aiDisabled) {
                            EntityHelperImpl.this.toggleAI(entity, false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    @Override
    public void sendHidePacket(Player pl, org.bukkit.entity.Entity entity) {
        if (entity instanceof Player) {
            this.ensurePlayerHiding();
            pl.hidePlayer((Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().world).getChunkProvider().playerChunkMap;
            Entity other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
            }
        }
    }

    @Override
    public void sendShowPacket(Player pl, org.bukkit.entity.Entity entity) {
        if (entity instanceof Player) {
            pl.showPlayer((Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            PlayerChunkMap tracker = ((WorldServer)craftPlayer.getHandle().world).getChunkProvider().playerChunkMap;
            Entity other = ((CraftEntity)entity).getHandle();
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
                entry.updatePlayer(entityPlayer);
            }
        }
    }

    @Override
    public void rotate(org.bukkit.entity.Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            entity.teleport(location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = this.normalizeYaw(yaw - 180.0f);
            }
            this.look(entity, yaw, pitch);
        } else {
            Entity handle = ((CraftEntity)entity).getHandle();
            handle.yaw = yaw;
            handle.pitch = pitch;
        }
    }

    @Override
    public float getBaseYaw(org.bukkit.entity.Entity entity) {
        Entity handle = ((CraftEntity)entity).getHandle();
        return ((EntityLiving)handle).aL;
    }

    @Override
    public void look(org.bukkit.entity.Entity entity, float yaw, float pitch) {
        Entity handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.yaw = yaw;
            if (handle instanceof EntityLiving) {
                EntityLiving livingHandle = (EntityLiving)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aL = yaw;
                if (!(handle instanceof EntityHuman)) {
                    livingHandle.aK = yaw;
                }
                livingHandle.aM = yaw;
            }
            handle.pitch = pitch;
        }
    }

    private static MovingObjectPosition rayTrace(org.bukkit.World world, Vector start, Vector end) {
        return ((CraftWorld)world).getHandle().rayTrace(new RayTrace(new Vec3D(start.getX(), start.getY(), start.getZ()), new Vec3D(end.getX(), end.getY(), end.getZ()), RayTrace.BlockCollisionOption.OUTLINE, RayTrace.FluidCollisionOption.NONE, null));
    }

    @Override
    public boolean canTrace(org.bukkit.World world, Vector start, Vector end) {
        return EntityHelperImpl.rayTrace(world, start, end) == null;
    }

    @Override
    public EntityHelper.MapTraceResult mapTrace(LivingEntity from, double range) {
        Location start = from.getEyeLocation();
        Vector startVec = start.toVector();
        double xzLen = Math.cos((double)(start.getPitch() % 360.0f) * (Math.PI / 180));
        double nx = xzLen * Math.sin((double)(-start.getYaw()) * (Math.PI / 180));
        double ny = Math.sin((double)start.getPitch() * (Math.PI / 180));
        double nz = xzLen * Math.cos((double)start.getYaw() * (Math.PI / 180));
        Vector endVec = startVec.clone().add(new Vector(nx, -ny, nz).multiply(range));
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, endVec);
        if (!(l instanceof MovingObjectPositionBlock) || l.getPos() == null) {
            return null;
        }
        Vector finalVec = new Vector(l.getPos().x, l.getPos().y, l.getPos().z);
        EntityHelper.MapTraceResult mtr = new EntityHelper.MapTraceResult();
        switch (((MovingObjectPositionBlock)l).getDirection()) {
            case NORTH: {
                mtr.angle = BlockFace.NORTH;
                break;
            }
            case SOUTH: {
                mtr.angle = BlockFace.SOUTH;
                break;
            }
            case EAST: {
                mtr.angle = BlockFace.EAST;
                break;
            }
            case WEST: {
                mtr.angle = BlockFace.WEST;
            }
        }
        Vector hit = finalVec.clone().subtract(endVec.clone().subtract(startVec).normalize().multiply(0.072));
        mtr.hitLocation = new Location(start.getWorld(), hit.getX(), hit.getY(), hit.getZ());
        return mtr;
    }

    @Override
    public Location rayTraceBlock(Location start, Vector direction, double range) {
        Vector startVec = start.toVector();
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, startVec.clone().add(direction.multiply(range)));
        if (l instanceof MovingObjectPositionBlock && l.getPos() != null) {
            return new Location(start.getWorld(), l.getPos().x - (double)((MovingObjectPositionBlock)l).getDirection().getAdjacentX() * 0.05, l.getPos().y - (double)((MovingObjectPositionBlock)l).getDirection().getAdjacentY() * 0.05, l.getPos().z - (double)((MovingObjectPositionBlock)l).getDirection().getAdjacentZ() * 0.05);
        }
        return null;
    }

    @Override
    public Location rayTrace(Location start, Vector direction, double range) {
        Vector startVec = start.toVector();
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, startVec.clone().add(direction.multiply(range)));
        if (l != null && l.getPos() != null) {
            return new Location(start.getWorld(), l.getPos().x, l.getPos().y, l.getPos().z);
        }
        return null;
    }

    @Override
    public Location getImpactNormal(Location start, Vector direction, double range) {
        Vector startVec = start.toVector();
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, startVec.clone().add(direction.multiply(range)));
        if (l instanceof MovingObjectPositionBlock && ((MovingObjectPositionBlock)l).getDirection() != null) {
            return new Location(start.getWorld(), (double)((MovingObjectPositionBlock)l).getDirection().getAdjacentX(), (double)((MovingObjectPositionBlock)l).getDirection().getAdjacentY(), (double)((MovingObjectPositionBlock)l).getDirection().getAdjacentZ());
        }
        return null;
    }

    @Override
    public void move(org.bukkit.entity.Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().move(EnumMoveType.SELF, new Vec3D(vector.getX(), vector.getY(), vector.getZ()));
    }

    @Override
    public void teleport(org.bukkit.entity.Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().setPosition(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public BoundingBox getBoundingBox(org.bukkit.entity.Entity entity) {
        AxisAlignedBB boundingBox = ((CraftEntity)entity).getHandle().getBoundingBox();
        Vector position = new Vector(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
        Vector size = new Vector(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
        return new BoundingBox(position, size);
    }

    @Override
    public void setBoundingBox(org.bukkit.entity.Entity entity, BoundingBox boundingBox) {
        Vector low = boundingBox.getLow();
        Vector high = boundingBox.getHigh();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(low.getX(), low.getY(), low.getZ(), high.getX(), high.getY(), high.getZ()));
    }

    @Override
    public boolean isChestedHorse(org.bukkit.entity.Entity horse) {
        return horse instanceof ChestedHorse;
    }

    @Override
    public boolean isCarryingChest(org.bukkit.entity.Entity horse) {
        return horse instanceof ChestedHorse && ((ChestedHorse)horse).isCarryingChest();
    }

    @Override
    public void setCarryingChest(org.bukkit.entity.Entity horse, boolean carrying) {
        if (horse instanceof ChestedHorse) {
            ((ChestedHorse)horse).setCarryingChest(carrying);
        }
    }

    @Override
    public BlockData getBlockDataFor(FallingBlock entity) {
        return new BlockDataImpl(entity.getBlockData());
    }
}

