/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.npc.DenizenNPCHelper;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.npc.traits.ConstantsTrait;
import com.denizenscript.denizen.npc.traits.FishingTrait;
import com.denizenscript.denizen.npc.traits.HealthTrait;
import com.denizenscript.denizen.npc.traits.NicknameTrait;
import com.denizenscript.denizen.npc.traits.PushableTrait;
import com.denizenscript.denizen.npc.traits.SneakingTrait;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.npc.EngageCommand;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.tags.core.NPCTagBase;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.waypoint.WanderWaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Anchor;
import net.citizensnpcs.util.Pose;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

public class NPCTag
implements ObjectTag,
Adjustable,
InventoryHolder,
EntityFormObject {
    private int npcid = -1;
    private final Location locationCache = new Location(null, 0.0, 0.0, 0.0);
    private String prefix = "npc";

    public static NPCTag mirrorCitizensNPC(NPC npc) {
        return new NPCTag(npc);
    }

    public static NPCTag fromEntity(Entity entity) {
        return NPCTag.mirrorCitizensNPC(CitizensAPI.getNPCRegistry().getNPC(entity));
    }

    public static NPCTag valueOf(String string) {
        return NPCTag.valueOf(string, null);
    }

    @Fetchable(value="n")
    public static NPCTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (ArgumentHelper.matchesInteger(string = string.toUpperCase().replace("N@", ""))) {
            int id = ArgumentHelper.getIntegerFrom(string);
            NPC npc = CitizensAPI.getNPCRegistry().getById(id);
            if (npc != null) {
                return new NPCTag(npc);
            }
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("n@")) {
            return true;
        }
        if (ArgumentHelper.matchesInteger(string = string.toUpperCase().replace("N@", ""))) {
            NPC npc = CitizensAPI.getNPCRegistry().getById(ArgumentHelper.getIntegerFrom(string));
            if (npc != null) {
                return true;
            }
        } else {
            for (NPC test : CitizensAPI.getNPCRegistry()) {
                if (!test.getName().equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.getCitizen() != null;
    }

    public NPCTag(NPC citizensNPC) {
        if (citizensNPC != null) {
            this.npcid = citizensNPC.getId();
        }
    }

    public NPC getCitizen() {
        if (this.npcid < 0) {
            return null;
        }
        NPC npc = CitizensAPI.getNPCRegistry().getById(this.npcid);
        if (npc == null) {
            // empty if block
        }
        return npc;
    }

    public Entity getEntity() {
        try {
            return this.getCitizen().getEntity();
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC entity. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public LivingEntity getLivingEntity() {
        try {
            if (this.getCitizen().getEntity() instanceof LivingEntity) {
                return (LivingEntity)this.getCitizen().getEntity();
            }
            Debug.log("Uh oh! Tried to get the living entity of a non-living NPC!");
            return null;
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC livingEntity. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    @Override
    public EntityTag getDenizenEntity() {
        try {
            return new EntityTag(this.getCitizen().getEntity());
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC EntityTag. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public org.bukkit.inventory.Inventory getInventory() {
        return DenizenNPCHelper.getInventory(this.getCitizen());
    }

    public InventoryTag getDenizenInventory() {
        return new InventoryTag(this);
    }

    public EntityType getEntityType() {
        return this.getCitizen().getEntity().getType();
    }

    public Navigator getNavigator() {
        return this.getCitizen().getNavigator();
    }

    public int getId() {
        return this.npcid;
    }

    public String getName() {
        return this.getCitizen().getName();
    }

    public InteractScriptContainer getInteractScript(PlayerTag player, Class<? extends AbstractTrigger> triggerType) {
        return InteractScriptHelper.getInteractScript(this, player, triggerType);
    }

    public InteractScriptContainer getInteractScriptQuietly(PlayerTag player, Class<? extends AbstractTrigger> triggerType) {
        InteractScriptHelper.debugGet = false;
        InteractScriptContainer script = InteractScriptHelper.getInteractScript(this, player, triggerType);
        InteractScriptHelper.debugGet = true;
        return script;
    }

    public void destroy() {
        this.getCitizen().destroy();
    }

    public LocationTag getLocation() {
        if (this.isSpawned()) {
            return new LocationTag(this.getEntity().getLocation());
        }
        return new LocationTag(this.getCitizen().getStoredLocation());
    }

    public LocationTag getEyeLocation() {
        if (this.isSpawned() && this.getCitizen().getEntity() instanceof LivingEntity) {
            return new LocationTag(((LivingEntity)this.getCitizen().getEntity()).getEyeLocation());
        }
        if (this.isSpawned()) {
            return new LocationTag(this.getEntity().getLocation());
        }
        return new LocationTag(this.getCitizen().getStoredLocation());
    }

    public World getWorld() {
        if (this.isSpawned()) {
            return this.getEntity().getWorld();
        }
        return null;
    }

    public String toString() {
        return this.identify();
    }

    public boolean isEngaged() {
        return EngageCommand.getEngaged(this.getCitizen());
    }

    public boolean isSpawned() {
        NPC npc = CitizensAPI.getNPCRegistry().getById(this.npcid);
        return npc != null && npc.isSpawned();
    }

    public String getOwner() {
        if (((Owner)this.getCitizen().getTrait(Owner.class)).getOwnerId() == null) {
            return ((Owner)this.getCitizen().getTrait(Owner.class)).getOwner();
        }
        return ((Owner)this.getCitizen().getTrait(Owner.class)).getOwnerId().toString();
    }

    public AssignmentTrait getAssignmentTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(AssignmentTrait.class)) {
            npc.addTrait(AssignmentTrait.class);
        }
        return (AssignmentTrait)npc.getTrait(AssignmentTrait.class);
    }

    public Equipment getEquipmentTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(Equipment.class)) {
            npc.addTrait(Equipment.class);
        }
        return (Equipment)npc.getTrait(Equipment.class);
    }

    public NicknameTrait getNicknameTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(NicknameTrait.class)) {
            npc.addTrait(NicknameTrait.class);
        }
        return (NicknameTrait)npc.getTrait(NicknameTrait.class);
    }

    public FishingTrait getFishingTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(FishingTrait.class)) {
            npc.addTrait(FishingTrait.class);
        }
        return (FishingTrait)npc.getTrait(FishingTrait.class);
    }

    public HealthTrait getHealthTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(HealthTrait.class)) {
            npc.addTrait(HealthTrait.class);
        }
        return (HealthTrait)npc.getTrait(HealthTrait.class);
    }

    public Inventory getInventoryTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(Inventory.class)) {
            npc.addTrait(Inventory.class);
        }
        return (Inventory)npc.getTrait(Inventory.class);
    }

    public PushableTrait getPushableTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(PushableTrait.class)) {
            npc.addTrait(PushableTrait.class);
        }
        return (PushableTrait)npc.getTrait(PushableTrait.class);
    }

    public LookClose getLookCloseTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(LookClose.class)) {
            npc.addTrait(LookClose.class);
        }
        return (LookClose)npc.getTrait(LookClose.class);
    }

    public TriggerTrait getTriggerTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(TriggerTrait.class)) {
            npc.addTrait(TriggerTrait.class);
        }
        return (TriggerTrait)npc.getTrait(TriggerTrait.class);
    }

    public String action(String actionName, PlayerTag player, Map<String, ObjectTag> context) {
        if (this.getCitizen() != null && this.getCitizen().hasTrait(AssignmentTrait.class)) {
            return DenizenAPI.getCurrentInstance().getNPCHelper().getActionHandler().doAction(actionName, this, player, this.getAssignmentTrait().getAssignment(), context);
        }
        return "none";
    }

    public String action(String actionName, PlayerTag player) {
        return this.action(actionName, player, null);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debuggable() {
        return "n@" + this.npcid + "<GR> (" + this.getName() + ")";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "NPC";
    }

    @Override
    public String identify() {
        return "n@" + this.npcid;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    @Override
    public NPCTag setPrefix(String prefix) {
        return this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof NPCTag)) {
            return false;
        }
        return this.getId() == ((NPCTag)o).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        NPC citizen;
        String flag_name;
        Object trait;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_npc")) {
            return new ElementTag(true).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location") && !this.isSpawned()) {
            return this.getLocation().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("eye_location")) {
            return this.getEyeLocation().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_nickname")) {
            NPC citizen2 = this.getCitizen();
            return new ElementTag(citizen2.hasTrait(NicknameTrait.class) && ((NicknameTrait)citizen2.getTrait(NicknameTrait.class)).hasNickname()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name.nickname")) {
            return new ElementTag(this.getCitizen().hasTrait(NicknameTrait.class) ? ((NicknameTrait)this.getCitizen().getTrait(NicknameTrait.class)).getNickname() : this.getName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name")) {
            return new ElementTag(this.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_traits")) {
            ArrayList<String> list = new ArrayList<String>();
            for (Trait trait2 : this.getCitizen().getTraits()) {
                list.add(trait2.getName());
            }
            return new ListTag((List<String>)list).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_trait") && attribute.hasContext(1) && (trait = CitizensAPI.getTraitFactory().getTraitClass(attribute.getContext(1))) != null) {
            return new ElementTag(this.getCitizen().hasTrait((Class)trait)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("pushable") || attribute.startsWith("is_pushable")) {
            return new ElementTag(this.getPushableTrait().isPushable()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_trigger") && attribute.hasContext(1)) {
            if (!this.getCitizen().hasTrait(TriggerTrait.class)) {
                return new ElementTag(false).getAttribute(attribute.fulfill(1));
            }
            trait = (TriggerTrait)this.getCitizen().getTrait(TriggerTrait.class);
            return new ElementTag(((TriggerTrait)((Object)trait)).hasTrigger(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("anchor.list") || attribute.startsWith("anchors.list")) {
            ArrayList<String> list = new ArrayList<String>();
            for (Anchor anchor : ((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchors()) {
                list.add(anchor.getName());
            }
            return new ListTag((List<String>)list).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("has_anchors")) {
            return new ElementTag(((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchors().size() > 0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("anchor") && attribute.hasContext(1) && ((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchor(attribute.getContext(1)) != null) {
            return new LocationTag(((Anchors)this.getCitizen().getTrait(Anchors.class)).getAnchor(attribute.getContext(1)).getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_flag")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            flag_name = attribute.getContext(1);
            return new ElementTag(FlagManager.npcHasFlag(this, flag_name)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flag")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            flag_name = attribute.getContext(1);
            if (attribute.getAttribute(2).equalsIgnoreCase("is_expired") || attribute.startsWith("isexpired")) {
                return new ElementTag(!FlagManager.npcHasFlag(this, flag_name)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).equalsIgnoreCase("size") && !FlagManager.npcHasFlag(this, flag_name)) {
                return new ElementTag(0).getAttribute(attribute.fulfill(2));
            }
            if (FlagManager.npcHasFlag(this, flag_name)) {
                FlagManager.Flag flag = DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(this.getId(), flag_name);
                return new ListTag(flag.toString(), true, flag.values()).getAttribute(attribute.fulfill(1));
            }
            return new ElementTag(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("list_flags")) {
            ListTag allFlags = new ListTag(DenizenAPI.getCurrentInstance().flagManager().listNPCFlags(this.getId()));
            ListTag searchFlags = null;
            if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                searchFlags = new ListTag();
                String search = attribute.getContext(1);
                if (search.startsWith("regex:")) {
                    try {
                        Pattern pattern = Pattern.compile(search.substring(6), 2);
                        for (String flag : allFlags) {
                            if (!pattern.matcher(flag).matches()) continue;
                            searchFlags.add(flag);
                        }
                    }
                    catch (Exception e) {
                        Debug.echoError(e);
                    }
                } else {
                    search = CoreUtilities.toLowerCase(search);
                    for (String flag : allFlags) {
                        if (!CoreUtilities.toLowerCase(flag).contains(search)) continue;
                        searchFlags.add(flag);
                    }
                }
            }
            return searchFlags == null ? allFlags.getAttribute(attribute.fulfill(1)) : searchFlags.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("constant") && attribute.hasContext(1)) {
            if (this.getCitizen().hasTrait(ConstantsTrait.class) && ((ConstantsTrait)this.getCitizen().getTrait(ConstantsTrait.class)).getConstant(attribute.getContext(1)) != null) {
                return new ElementTag(((ConstantsTrait)this.getCitizen().getTrait(ConstantsTrait.class)).getConstant(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("has_pose")) {
            if (attribute.hasContext(1)) {
                return new ElementTag(((Poses)this.getCitizen().getTrait(Poses.class)).hasPose(attribute.getContext(1))).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("pose") || attribute.startsWith("get_pose")) {
            if (attribute.hasContext(1)) {
                Pose pose = ((Poses)this.getCitizen().getTrait(Poses.class)).getPose(attribute.getContext(1));
                return new LocationTag((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0, pose.getYaw(), pose.getPitch()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("is_sneaking") && this.isSpawned() && this.getEntity() instanceof Player) {
            return new ElementTag(((Player)this.getEntity()).isSneaking()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("engaged") || attribute.startsWith("is_engaged")) {
            return new ElementTag(this.isEngaged()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("invulnerable") || attribute.startsWith("vulnerable")) {
            return new ElementTag((Boolean)this.getCitizen().data().get("protected", (Object)true)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("id")) {
            return new ElementTag(this.getId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("owner")) {
            String owner = this.getOwner();
            PlayerTag player = null;
            if (!owner.equalsIgnoreCase("server")) {
                player = PlayerTag.valueOfInternal(owner, false);
            }
            if (player != null) {
                return player.getAttribute(attribute.fulfill(1));
            }
            return new ElementTag(owner).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_skin")) {
            return new ElementTag(this.getCitizen().data().has("player-skin-name")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("skin_blob") && this.getCitizen().data().has("player-skin-textures")) {
            String tex = this.getCitizen().data().get("player-skin-textures").toString();
            String sign = "";
            if (this.getCitizen().data().has("player-skin-signature")) {
                sign = ";" + this.getCitizen().data().get("player-skin-signature").toString();
            }
            return new ElementTag(tex + sign).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("skin") && this.getCitizen().data().has("player-skin-name")) {
            return new ElementTag(this.getCitizen().data().get("player-skin-name").toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory")) {
            return this.getDenizenInventory().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_spawned")) {
            return new ElementTag(this.isSpawned()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_protected")) {
            return new ElementTag(this.getCitizen().isProtected()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("lookclose")) {
            citizen = this.getCitizen();
            if (citizen.hasTrait(LookClose.class)) {
                String lookclose = ((LookClose)citizen.getTrait(LookClose.class)).toString();
                lookclose = lookclose.substring(10, lookclose.length() - 1);
                return new ElementTag(Boolean.valueOf(lookclose)).getAttribute(attribute.fulfill(1));
            }
            return new ElementTag(false).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location.previous_location")) {
            return NPCTagBase.previousLocations.containsKey(this.getId()) ? NPCTagBase.previousLocations.get(this.getId()).getAttribute(attribute.fulfill(2)) : null;
        }
        if (attribute.startsWith("teleport_on_stuck")) {
            return new ElementTag(this.getNavigator().getDefaultParameters().stuckAction() == TeleportStuckAction.INSTANCE).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_script")) {
            citizen = this.getCitizen();
            return new ElementTag(citizen.hasTrait(AssignmentTrait.class) && ((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).hasAssignment()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("script")) {
            citizen = this.getCitizen();
            if (!citizen.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).hasAssignment()) {
                return null;
            }
            return new ScriptTag(((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).getAssignment().getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("navigator.is_navigating")) {
            return new ElementTag(this.getNavigator().isNavigating()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.speed")) {
            return new ElementTag(this.getNavigator().getLocalParameters().speed()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.range")) {
            return new ElementTag(this.getNavigator().getLocalParameters().range()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.attack_range")) {
            return new ElementTag(this.getNavigator().getLocalParameters().attackRange()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.attack_strategy")) {
            return new ElementTag(this.getNavigator().getLocalParameters().attackStrategy().toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.speed_modifier")) {
            return new ElementTag(this.getNavigator().getLocalParameters().speedModifier()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.base_speed")) {
            return new ElementTag(this.getNavigator().getLocalParameters().baseSpeed()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.avoid_water")) {
            return new ElementTag(this.getNavigator().getLocalParameters().avoidWater()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.target_location")) {
            return this.getNavigator().getTargetAsLocation() != null ? new LocationTag(this.getNavigator().getTargetAsLocation()).getAttribute(attribute.fulfill(2)) : null;
        }
        if (attribute.startsWith("navigator.is_fighting")) {
            return new ElementTag(this.getNavigator().getEntityTarget() != null && this.getNavigator().getEntityTarget().isAggressive()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.target_type")) {
            return new ElementTag(this.getNavigator().getTargetType() == null ? "null" : this.getNavigator().getTargetType().toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("navigator.target_entity")) {
            return this.getNavigator().getEntityTarget() != null && this.getNavigator().getEntityTarget().getTarget() != null ? new EntityTag(this.getNavigator().getEntityTarget().getTarget()).getAttribute(attribute.fulfill(2)) : null;
        }
        if (attribute.startsWith("type")) {
            return new ElementTag("NPC").getAttribute(attribute.fulfill(1));
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return this.getEntity() != null ? new EntityTag(this).getAttribute(attribute) : new ElementTag(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to an NPC!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Waypoints wp;
        if (mechanism.matches("set_assignment") && mechanism.requireObject(ScriptTag.class)) {
            this.getAssignmentTrait().setAssignment(mechanism.valueAsType(ScriptTag.class).getName(), null);
        }
        if (mechanism.matches("remove_assignment")) {
            this.getAssignmentTrait().removeAssignment(null);
        }
        if (mechanism.matches("set_nickname")) {
            this.getNicknameTrait().setNickname(mechanism.getValue().asString());
        }
        if (mechanism.matches("remove_nickname")) {
            this.getNicknameTrait().removeNickname();
        }
        if (mechanism.matches("set_entity_type") && mechanism.requireObject(EntityTag.class)) {
            this.getCitizen().setBukkitEntityType(mechanism.valueAsType(EntityTag.class).getBukkitEntityType());
        }
        if (mechanism.matches("name") || mechanism.matches("set_name")) {
            this.getCitizen().setName(mechanism.getValue().asString().length() > 64 ? mechanism.getValue().asString().substring(0, 64) : mechanism.getValue().asString());
        }
        if (mechanism.matches("owner")) {
            ((Owner)this.getCitizen().getTrait(Owner.class)).setOwner(mechanism.getValue().asString());
        }
        if (mechanism.matches("skin_blob")) {
            if (!mechanism.hasValue()) {
                this.getCitizen().data().remove("cached-skin-uuid");
                this.getCitizen().data().remove("player-skin-textures");
                this.getCitizen().data().remove("player-skin-signature");
                if (this.getCitizen().isSpawned()) {
                    this.getCitizen().despawn(DespawnReason.PENDING_RESPAWN);
                    this.getCitizen().spawn(this.getCitizen().getStoredLocation());
                }
            } else {
                String[] dat = mechanism.getValue().asString().split(";");
                this.getCitizen().data().remove("cached-skin-uuid");
                this.getCitizen().data().setPersistent("player-skin-textures", (Object)dat[0]);
                this.getCitizen().data().setPersistent("player-skin-signature", dat.length > 1 ? dat[1] : null);
                if (dat.length > 2) {
                    this.getCitizen().data().setPersistent("player-skin-name", (Object)dat[2]);
                }
                if (this.getCitizen().isSpawned() && this.getCitizen().getEntity() instanceof SkinnableEntity) {
                    ((SkinnableEntity)this.getCitizen().getEntity()).setSkinPersistent(dat.length > 2 ? dat[2] : "unspecified", dat.length > 1 ? dat[1] : null, dat[0]);
                    ((SkinnableEntity)this.getCitizen().getEntity()).getSkinTracker().notifySkinChange(true);
                }
            }
        }
        if (mechanism.matches("skin")) {
            if (!mechanism.hasValue()) {
                this.getCitizen().data().remove("player-skin-name");
            } else {
                this.getCitizen().data().setPersistent("player-skin-name", (Object)mechanism.getValue().asString());
            }
            if (this.getCitizen().isSpawned()) {
                this.getCitizen().despawn(DespawnReason.PENDING_RESPAWN);
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("item_type") && mechanism.requireObject(ItemTag.class)) {
            ItemTag item = mechanism.valueAsType(ItemTag.class);
            Material mat = item.getMaterial().getMaterial();
            byte data = item.getMaterial().getData((byte)0);
            switch (this.getEntity().getType()) {
                case DROPPED_ITEM: {
                    ((Item)this.getEntity()).getItemStack().setType(mat);
                    break;
                }
                case ITEM_FRAME: {
                    ((ItemFrame)this.getEntity()).getItem().setType(mat);
                    break;
                }
                case FALLING_BLOCK: {
                    break;
                }
                default: {
                    Debug.echoError("NPC is the not an item type!");
                }
            }
            if (this.getCitizen().isSpawned()) {
                this.getCitizen().despawn();
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("spawn")) {
            if (mechanism.requireObject("Invalid LocationTag specified. Assuming last known NPC location.", LocationTag.class)) {
                this.getCitizen().spawn((Location)mechanism.valueAsType(LocationTag.class));
            } else {
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("range") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().range(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("attack_range") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().attackRange((double)mechanism.getValue().asFloat());
        }
        if (mechanism.matches("speed") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().speedModifier(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("despawn")) {
            this.getCitizen().despawn(DespawnReason.PLUGIN);
        }
        if (mechanism.matches("set_sneaking") && mechanism.requireBoolean()) {
            SneakingTrait trait;
            if (!this.getCitizen().hasTrait(SneakingTrait.class)) {
                this.getCitizen().addTrait(SneakingTrait.class);
            }
            if ((trait = (SneakingTrait)this.getCitizen().getTrait(SneakingTrait.class)).isSneaking() && !mechanism.getValue().asBoolean()) {
                trait.sneak();
            } else if (!trait.isSneaking() && mechanism.getValue().asBoolean()) {
                trait.stand();
            }
        }
        if (mechanism.matches("set_protected") && mechanism.requireBoolean()) {
            this.getCitizen().setProtected(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("lookclose") && mechanism.requireBoolean()) {
            this.getLookCloseTrait().lookClose(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("teleport_on_stuck") && mechanism.requireBoolean()) {
            if (mechanism.getValue().asBoolean()) {
                this.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
            } else {
                this.getNavigator().getDefaultParameters().stuckAction(null);
            }
        }
        if (mechanism.matches("set_distance") && mechanism.requireDouble()) {
            this.getNavigator().getDefaultParameters().distanceMargin(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("name_visible")) {
            this.getCitizen().data().setPersistent("nameplate-visible", (Object)mechanism.getValue().asString());
        }
        if (mechanism.matches("clear_waypoints")) {
            if (!this.getCitizen().hasTrait(Waypoints.class)) {
                this.getCitizen().addTrait(Waypoints.class);
            }
            if ((wp = (Waypoints)this.getCitizen().getTrait(Waypoints.class)).getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider) {
                ((List)((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()).clear();
            } else if (wp.getCurrentProvider() instanceof WanderWaypointProvider) {
                List locs = ((WanderWaypointProvider)wp.getCurrentProvider()).getRegionCentres();
                for (Location loc : locs) {
                    locs.remove(loc);
                }
            }
        }
        if (mechanism.matches("add_waypoint") && mechanism.requireObject(LocationTag.class)) {
            if (!this.getCitizen().hasTrait(Waypoints.class)) {
                this.getCitizen().addTrait(Waypoints.class);
            }
            if ((wp = (Waypoints)this.getCitizen().getTrait(Waypoints.class)).getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider) {
                ((List)((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()).add(new Waypoint((Location)mechanism.valueAsType(LocationTag.class)));
            } else if (wp.getCurrentProvider() instanceof WanderWaypointProvider) {
                ((WanderWaypointProvider)wp.getCurrentProvider()).getRegionCentres().add(mechanism.valueAsType(LocationTag.class));
            }
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
        if (!mechanism.fulfilled() && this.isSpawned()) {
            new EntityTag(this.getEntity()).adjust(mechanism);
        }
    }
}

