/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.bukkit;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;

public class BukkitQueueProperties
implements Property {
    public static final String[] handledTags = new String[]{"player", "npc"};
    public static final String[] handledMechs = new String[]{"linked_player", "linked_npc"};
    ScriptQueue queue;

    public static boolean describes(ObjectTag script) {
        return script instanceof QueueTag;
    }

    public static BukkitQueueProperties getFrom(ObjectTag queue) {
        if (!BukkitQueueProperties.describes(queue)) {
            return null;
        }
        return new BukkitQueueProperties((QueueTag)queue);
    }

    private BukkitQueueProperties(QueueTag queue) {
        this.queue = queue.queue;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("npc")) {
            NPCTag npc = null;
            if (this.queue.getLastEntryExecuted() != null) {
                npc = ((BukkitScriptEntryData)this.queue.getLastEntryExecuted().entryData).getNPC();
            } else if (this.queue.getEntries().size() > 0) {
                npc = ((BukkitScriptEntryData)this.queue.getEntries().get((int)0).entryData).getNPC();
            } else {
                Debug.echoError(this.queue, "Can't determine a linked NPC.");
            }
            if (npc == null) {
                return null;
            }
            return npc.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("player")) {
            PlayerTag player = null;
            if (this.queue.getLastEntryExecuted() != null) {
                player = ((BukkitScriptEntryData)this.queue.getLastEntryExecuted().entryData).getPlayer();
            } else if (this.queue.getEntries().size() > 0) {
                player = ((BukkitScriptEntryData)this.queue.getEntries().get((int)0).entryData).getPlayer();
            } else {
                Debug.echoError(this.queue, "Can't determine a linked player.");
            }
            if (player == null) {
                return null;
            }
            return player.getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "BukkitQueueProperties";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        BukkitScriptEntryData data;
        if (mechanism.matches("linked_player") && mechanism.requireObject(PlayerTag.class)) {
            PlayerTag player = mechanism.valueAsType(PlayerTag.class);
            for (ScriptEntry entry : this.queue.getEntries()) {
                data = (BukkitScriptEntryData)entry.entryData;
                data.setPlayer(player);
            }
        }
        if (mechanism.matches("linked_npc") && mechanism.requireObject(NPCTag.class)) {
            NPCTag npc = mechanism.valueAsType(NPCTag.class);
            for (ScriptEntry entry : this.queue.getEntries()) {
                data = (BukkitScriptEntryData)entry.entryData;
                data.setNPC(npc);
            }
        }
    }
}

