/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Skeleton;

public class EntitySkeleton
implements Property {
    public static final String[] handledTags = new String[]{"skeleton_type"};
    public static final String[] handledMechs = new String[]{"skeleton"};
    EntityTag skeleton;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Skeleton;
    }

    public static EntitySkeleton getFrom(ObjectTag entity) {
        if (!EntitySkeleton.describes(entity)) {
            return null;
        }
        return new EntitySkeleton((EntityTag)entity);
    }

    private EntitySkeleton(EntityTag entity) {
        this.skeleton = entity;
    }

    @Override
    public String getPropertyString() {
        return ((Skeleton)this.skeleton.getBukkitEntity()).getSkeletonType().name();
    }

    @Override
    public String getPropertyId() {
        return "skeleton";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("skeleton_type")) {
            Debug.echoError("Different skeleton types are represented by different entity types. Please remove usage of the 'skeleton_type' tag.");
            return new ElementTag(((Skeleton)this.skeleton.getBukkitEntity()).getSkeletonType().name()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("skeleton") && mechanism.requireEnum(false, (Enum<?>[])Skeleton.SkeletonType.values())) {
            Debug.echoError("Different skeleton types are represented by different entity types. Please remove usage of the 'skeleton:<type>' mechanism.");
            String skelGoal = mechanism.getValue().asString().toUpperCase();
            if (((Skeleton)this.skeleton.getBukkitEntity()).getSkeletonType().name().equals(skelGoal)) {
                return;
            }
            Skeleton.SkeletonType skeletonType = Skeleton.SkeletonType.valueOf((String)skelGoal);
            Skeleton current = (Skeleton)this.skeleton.getBukkitEntity();
            Skeleton newSkeleton = null;
            switch (skeletonType) {
                case NORMAL: {
                    newSkeleton = (Skeleton)current.getLocation().getWorld().spawnEntity(current.getLocation(), EntityType.SKELETON);
                    break;
                }
                case WITHER: {
                    newSkeleton = (Skeleton)current.getLocation().getWorld().spawnEntity(current.getLocation(), EntityType.WITHER_SKELETON);
                    break;
                }
                case STRAY: {
                    newSkeleton = (Skeleton)current.getLocation().getWorld().spawnEntity(current.getLocation(), EntityType.STRAY);
                }
            }
            newSkeleton.setHealth(current.getHealth());
            newSkeleton.getEquipment().setArmorContents(current.getEquipment().getArmorContents());
            current.remove();
            this.skeleton.setEntity((Entity)newSkeleton);
        }
    }
}

