/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Tameable;

public class EntityTame
implements Property {
    public static final String[] handledTags = new String[]{"is_tamed", "get_owner", "owner"};
    public static final String[] handledMechs = new String[]{"tame", "owner"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Tameable;
    }

    public static EntityTame getFrom(ObjectTag entity) {
        if (!EntityTame.describes(entity)) {
            return null;
        }
        return new EntityTame((EntityTag)entity);
    }

    private EntityTame(EntityTag tame) {
        this.entity = tame;
    }

    @Override
    public String getPropertyString() {
        if (((Tameable)this.entity.getBukkitEntity()).isTamed()) {
            OfflinePlayer owner = (OfflinePlayer)((Tameable)this.entity.getBukkitEntity()).getOwner();
            if (owner == null) {
                return "true";
            }
            return "true|" + owner.getUniqueId();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "tame";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_tamed")) {
            return new ElementTag(((Tameable)this.entity.getBukkitEntity()).isTamed()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("owner") || attribute.startsWith("get_owner")) {
            if (((Tameable)this.entity.getBukkitEntity()).isTamed()) {
                return new PlayerTag((OfflinePlayer)((Tameable)this.entity.getBukkitEntity()).getOwner()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("tame")) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            if (list.size() == 0) {
                Debug.echoError("Missing value for 'tame' mechanism!");
                return;
            }
            if (new ElementTag((String)list.get(0)).isBoolean()) {
                ((Tameable)this.entity.getBukkitEntity()).setTamed(mechanism.getValue().asBoolean());
            } else {
                Debug.echoError("Invalid boolean value!");
            }
            if (list.size() > 1 && new ElementTag((String)list.get(1)).matchesType(PlayerTag.class)) {
                ((Tameable)this.entity.getBukkitEntity()).setOwner((AnimalTamer)new ElementTag((String)list.get(1)).asType(PlayerTag.class, mechanism.context).getOfflinePlayer());
            }
        }
        if (mechanism.matches("owner")) {
            if (mechanism.hasValue() && mechanism.requireObject(PlayerTag.class)) {
                ((Tameable)this.entity.getBukkitEntity()).setOwner((AnimalTamer)mechanism.valueAsType(PlayerTag.class).getOfflinePlayer());
            } else {
                ((Tameable)this.entity.getBukkitEntity()).setOwner(null);
            }
        }
    }
}

