/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.npc.traits.InvisibleTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.ArmorStand;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class InvisibleCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("state") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("state", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matches("PLAYER") && Utilities.entryHasPlayer(scriptEntry)) {
                scriptEntry.addObject("target", Utilities.getEntryPlayer(scriptEntry).getDenizenEntity());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matches("NPC") && Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("target", Utilities.getEntryNPC(scriptEntry).getDenizenEntity());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("target", arg.asType(EntityTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("state")) {
            scriptEntry.addObject("state", new ElementTag("TRUE"));
        }
        if (!scriptEntry.hasObject("target") || !((EntityTag)scriptEntry.getObjectTag("target")).isValid()) {
            throw new InvalidArgumentsException("Must specify a valid target!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag state = scriptEntry.getElement("state");
        EntityTag target = (EntityTag)scriptEntry.getObject("target");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), state.debug() + target.debug());
        }
        if (target.isCitizensNPC()) {
            NPC npc = target.getDenizenNPC().getCitizen();
            if (!npc.hasTrait(InvisibleTrait.class)) {
                npc.addTrait(InvisibleTrait.class);
            }
            InvisibleTrait trait = (InvisibleTrait)npc.getTrait(InvisibleTrait.class);
            switch (Action.valueOf(state.asString().toUpperCase())) {
                case FALSE: {
                    trait.setInvisible(false);
                    break;
                }
                case TRUE: {
                    trait.setInvisible(true);
                    break;
                }
                case TOGGLE: {
                    trait.toggle();
                }
            }
        } else {
            switch (Action.valueOf(state.asString().toUpperCase())) {
                case FALSE: {
                    if (target.getBukkitEntity() instanceof ArmorStand) {
                        ((ArmorStand)target.getBukkitEntity()).setVisible(true);
                        break;
                    }
                    target.getLivingEntity().removePotionEffect(PotionEffectType.INVISIBILITY);
                    break;
                }
                case TRUE: {
                    if (target.getBukkitEntity() instanceof ArmorStand) {
                        ((ArmorStand)target.getBukkitEntity()).setVisible(false);
                        break;
                    }
                    new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1).apply(target.getLivingEntity());
                    break;
                }
                case TOGGLE: {
                    if (target.getBukkitEntity() instanceof ArmorStand) {
                        if (((ArmorStand)target.getBukkitEntity()).isVisible()) {
                            ((ArmorStand)target.getBukkitEntity()).setVisible(true);
                            break;
                        }
                        ((ArmorStand)target.getBukkitEntity()).setVisible(false);
                        break;
                    }
                    if (target.getLivingEntity().hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                        target.getLivingEntity().removePotionEffect(PotionEffectType.INVISIBILITY);
                        break;
                    }
                    new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1).apply(target.getLivingEntity());
                }
            }
        }
    }

    static enum Action {
        TRUE,
        FALSE,
        TOGGLE;

    }
}

