/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;

public class CreateWorldCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("generator") && arg.matchesPrefix("generator", "g")) {
                scriptEntry.addObject("generator", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("worldtype") && arg.matchesPrefix("worldtype") && arg.matchesEnum((Enum<?>[])WorldType.values())) {
                scriptEntry.addObject("worldtype", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("environment") && arg.matchesPrefix("environment") && arg.matchesEnum((Enum<?>[])World.Environment.values())) {
                scriptEntry.addObject("environment", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("copy_from") && arg.matchesPrefix("copy_from")) {
                scriptEntry.addObject("copy_from", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("seed") && arg.matchesPrefix("seed", "s") && arg.matchesPrimitive(ArgumentHelper.PrimitiveType.Integer)) {
                scriptEntry.addObject("seed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("world_name")) {
                scriptEntry.addObject("world_name", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("world_name")) {
            throw new InvalidArgumentsException("Must specify a world name.");
        }
        if (!scriptEntry.hasObject("worldtype")) {
            scriptEntry.addObject("worldtype", new ElementTag("NORMAL"));
        }
        scriptEntry.defaultObject("environment", new ElementTag("NORMAL"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        World world;
        ElementTag worldName = scriptEntry.getElement("world_name");
        ElementTag generator = scriptEntry.getElement("generator");
        ElementTag worldType = scriptEntry.getElement("worldtype");
        ElementTag environment = scriptEntry.getElement("environment");
        ElementTag copy_from = scriptEntry.getElement("copy_from");
        ElementTag seed = scriptEntry.getElement("seed");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), worldName.debug() + (generator != null ? generator.debug() : "") + environment.debug() + (copy_from != null ? copy_from.debug() : "") + worldType.debug() + (seed != null ? seed.debug() : ""));
        }
        if (copy_from != null) {
            try {
                File file2;
                if (copy_from.asString().contains("..")) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid copy from world name!");
                    return;
                }
                File newFolder = new File(worldName.asString());
                File folder = new File(copy_from.asString().replace("w@", ""));
                if (!folder.exists() || !folder.isDirectory()) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid copy from world folder - does not exist!");
                    return;
                }
                CoreUtilities.copyDirectory(folder, newFolder);
                File file = new File(worldName.asString() + "/uid.dat");
                if (file.exists()) {
                    file.delete();
                }
                if ((file2 = new File(worldName.asString() + "/session.lock")).exists()) {
                    file2.delete();
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
                return;
            }
        }
        WorldCreator worldCreator = WorldCreator.name((String)worldName.asString()).environment(World.Environment.valueOf((String)environment.asString().toUpperCase())).type(WorldType.valueOf((String)worldType.asString().toUpperCase()));
        if (generator != null) {
            worldCreator.generator(generator.asString());
        }
        if (seed != null) {
            worldCreator.seed(seed.asLong());
        }
        if ((world = Bukkit.getServer().createWorld(worldCreator)) == null) {
            Debug.echoDebug((Debuggable)scriptEntry, "World is null, something went wrong in creation!");
        }
    }
}

