/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.MaterialCompat;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookScriptContainer
extends ScriptContainer {
    public BookScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public ItemTag getBookFrom() {
        return this.getBookFrom(null, null);
    }

    public ItemTag getBookFrom(PlayerTag player, NPCTag npc) {
        ItemTag stack = new ItemTag(Material.WRITTEN_BOOK);
        return this.writeBookTo(stack, player, npc);
    }

    public ItemTag writeBookTo(ItemTag book, PlayerTag player, NPCTag npc) {
        BookMeta bookInfo = (BookMeta)book.getItemStack().getItemMeta();
        if (this.contains("TITLE")) {
            String title = this.getString("TITLE");
            title = TagManager.tag(title, new BukkitTagContext(player, npc, false, null, this.shouldDebug(), new ScriptTag(this)));
            bookInfo.setTitle(title);
        }
        if (this.contains("SIGNED") && this.getString("SIGNED").equalsIgnoreCase("false")) {
            book.getItemStack().setType(MaterialCompat.WRITABLE_BOOK);
        }
        if (this.contains("AUTHOR")) {
            String author = this.getString("AUTHOR");
            author = TagManager.tag(author, new BukkitTagContext(player, npc, false, null, this.shouldDebug(), new ScriptTag(this)));
            bookInfo.setAuthor(author);
        }
        if (this.contains("TEXT")) {
            List<String> pages = this.getStringList("TEXT");
            for (String page : pages) {
                page = TagManager.tag(page, new BukkitTagContext(player, npc, false, null, this.shouldDebug(), new ScriptTag(this)));
                bookInfo.addPage(new String[]{page});
            }
        }
        book.getItemStack().setItemMeta((ItemMeta)bookInfo);
        return book;
    }
}

