/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.packets;

import com.denizenscript.denizen.events.player.PlayerReceivesMessageScriptEvent;
import com.denizenscript.denizen.events.player.PlayerSteersEntityScriptEvent;
import com.denizenscript.denizen.events.player.ResourcePackStatusScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.packets.PacketHandler;
import com.denizenscript.denizen.nms.interfaces.packets.PacketInResourcePackStatus;
import com.denizenscript.denizen.nms.interfaces.packets.PacketInSteerVehicle;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutChat;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutEntityMetadata;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutSetSlot;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutTradeList;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutWindowItems;
import com.denizenscript.denizen.nms.util.TradeOffer;
import com.denizenscript.denizen.nms.util.jnbt.StringTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.GlowCommand;
import com.denizenscript.denizen.scripts.commands.server.ExecuteCommand;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class DenizenPacketHandler
implements PacketHandler {
    @Override
    public void receivePacket(final Player player, final PacketInResourcePackStatus resourcePackStatus) {
        Bukkit.getScheduler().runTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                ResourcePackStatusScriptEvent event = ResourcePackStatusScriptEvent.instance;
                event.status = new ElementTag(resourcePackStatus.getStatus());
                event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
                event.fire();
            }
        });
    }

    @Override
    public boolean receivePacket(final Player player, final PacketInSteerVehicle steerVehicle) {
        if (PlayerSteersEntityScriptEvent.instance.enabled) {
            Future future = Bukkit.getScheduler().callSyncMethod((Plugin)DenizenAPI.getCurrentInstance(), (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    PlayerSteersEntityScriptEvent event = PlayerSteersEntityScriptEvent.instance;
                    event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
                    event.entity = player.isInsideVehicle() ? new EntityTag(player.getVehicle()) : null;
                    event.sideways = new ElementTag(steerVehicle.getLeftwardInput());
                    event.forward = new ElementTag(steerVehicle.getForwardInput());
                    event.jump = new ElementTag(steerVehicle.getJumpInput());
                    event.dismount = new ElementTag(steerVehicle.getDismountInput());
                    event.cancelled = false;
                    event.fire();
                    return event.cancelled;
                }
            });
            try {
                return (Boolean)future.get();
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
        return false;
    }

    @Override
    public boolean sendPacket(final Player player, final PacketOutChat chat) {
        if (ExecuteCommand.silencedPlayers.contains(player.getUniqueId())) {
            return true;
        }
        final PlayerReceivesMessageScriptEvent event = PlayerReceivesMessageScriptEvent.instance;
        if (event.loaded) {
            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    int pos = chat.getPosition();
                    if (pos != 2) {
                        event.message = new ElementTag(chat.getMessage());
                        event.rawJson = new ElementTag(chat.getRawJson());
                        event.system = new ElementTag(pos == 1);
                        event.messageModified = false;
                        event.rawJsonModified = false;
                        event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
                        event.cancelled = false;
                        event.fire();
                        if (event.messageModified) {
                            chat.setMessage(event.message.asString());
                        } else if (event.rawJsonModified) {
                            chat.setRawJson(event.rawJson.asString());
                        }
                        return event.cancelled;
                    }
                    return false;
                }
            });
            if (Bukkit.isPrimaryThread()) {
                futureTask.run();
            } else {
                Bukkit.getScheduler().runTask((Plugin)DenizenAPI.getCurrentInstance(), futureTask);
            }
            try {
                return futureTask.get();
            }
            catch (Exception e) {
                Debug.echoError(e);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean sendPacket(Player player, PacketOutEntityMetadata entityMetadata) {
        HashSet<UUID> players = GlowCommand.glowViewers.get(entityMetadata.getEntityId());
        return players != null && entityMetadata.checkForGlow() && !players.contains(player.getUniqueId());
    }

    @Override
    public boolean sendPacket(Player player, PacketOutSetSlot setSlot) {
        setSlot.setItemStack(DenizenPacketHandler.removeItemScriptLore(setSlot.getItemStack()));
        return false;
    }

    @Override
    public boolean sendPacket(Player player, PacketOutWindowItems windowItems) {
        ItemStack[] contents = windowItems.getContents();
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = DenizenPacketHandler.removeItemScriptLore(contents[i]);
        }
        windowItems.setContents(contents);
        return false;
    }

    @Override
    public boolean sendPacket(Player player, PacketOutTradeList tradeList) {
        List<TradeOffer> tradeOffers = tradeList.getTradeOffers();
        for (TradeOffer tradeOffer : tradeOffers) {
            tradeOffer.setFirstCost(DenizenPacketHandler.removeItemScriptLore(tradeOffer.getFirstCost()));
            tradeOffer.setSecondCost(DenizenPacketHandler.removeItemScriptLore(tradeOffer.getSecondCost()));
            tradeOffer.setProduct(DenizenPacketHandler.removeItemScriptLore(tradeOffer.getProduct()));
        }
        tradeList.setTradeOffers(tradeOffers);
        return false;
    }

    private static ItemStack removeItemScriptLore(ItemStack itemStack) {
        if (itemStack != null && itemStack.hasItemMeta() && itemStack.getItemMeta().hasLore()) {
            ItemMeta meta = itemStack.getItemMeta();
            List lore = meta.getLore();
            Iterator iter = lore.iterator();
            String hash = null;
            while (iter.hasNext()) {
                String line = (String)iter.next();
                if (!line.startsWith(ItemScriptHelper.ItemScriptHashID)) continue;
                hash = line;
                iter.remove();
                break;
            }
            if (hash != null) {
                meta.setLore(lore);
                itemStack.setItemMeta(meta);
                return NMSHandler.getItemHelper().addNbtData(itemStack, "Denizen Item Script", new StringTag(hash));
            }
        }
        return itemStack;
    }
}

