/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.core.ProcedureScriptContainer;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.NaturalOrderComparator;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ListTag
extends ArrayList<String>
implements ObjectTag,
ObjectTag.ObjectAttributable {
    public final ArrayList<ObjectTag> objectForms;
    public static final char internal_escape_char = '\u0005';
    public static final String internal_escape = String.valueOf('\u0005');
    private String prefix = "List";
    public String flag = null;
    public static HashMap<String, TagRunnable.ObjectForm> registeredObjectTags = new HashMap();

    @Override
    public boolean add(String addMe) {
        this.objectForms.add(new ElementTag(addMe));
        return super.add(addMe);
    }

    @Override
    public void add(int index, String addMe) {
        this.objectForms.add(index, new ElementTag(addMe));
        super.add(index, addMe);
    }

    @Override
    public boolean addAll(Collection<? extends String> addMe) {
        for (String string : addMe) {
            this.add(string);
        }
        return !addMe.isEmpty();
    }

    @Override
    public String remove(int index) {
        this.objectForms.remove(index);
        return (String)super.remove(index);
    }

    @Override
    public boolean remove(Object key) {
        int ind = super.indexOf(key);
        if (ind < 0 || ind >= this.size()) {
            return false;
        }
        this.remove(ind);
        return true;
    }

    public boolean addAll(ListTag inp) {
        this.objectForms.addAll(inp.objectForms);
        return super.addAll(inp);
    }

    public boolean addObject(ObjectTag obj) {
        this.objectForms.add(obj);
        return super.add(obj.toString());
    }

    public void addObject(int index, ObjectTag obj) {
        this.objectForms.add(index, obj);
        super.add(index, obj.toString());
    }

    public void setObject(int index, ObjectTag obj) {
        this.objectForms.set(index, obj);
        super.set(index, obj.toString());
    }

    public ObjectTag getObject(int id) {
        return this.objectForms.get(id);
    }

    public static ListTag valueOf(String string) {
        return ListTag.valueOf(string, null);
    }

    @Fetchable(value="li,fl")
    public static ListTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        ListTag list = DenizenCore.getImplementation().valueOfFlagListTag(string);
        if (list != null) {
            return list;
        }
        return new ListTag(string.startsWith("li@") ? string.substring(3) : string);
    }

    public static ListTag getListFor(ObjectTag inp) {
        return inp instanceof ListTag ? (ListTag)inp : ListTag.valueOf(inp.toString());
    }

    public static boolean matches(String arg) {
        boolean flag = DenizenCore.getImplementation().matchesFlagListTag(arg);
        return flag || arg.contains("|") || arg.contains(internal_escape) || arg.startsWith("li@");
    }

    public ListTag(Collection<? extends ObjectTag> objectTagList) {
        this.objectForms = new ArrayList<ObjectTag>(objectTagList);
        for (ObjectTag objectTag : objectTagList) {
            super.add(objectTag.identify());
        }
    }

    public ListTag() {
        this.objectForms = new ArrayList();
    }

    public ListTag(String items) {
        if (items != null && items.length() > 0) {
            int brackets = 0;
            int start = 0;
            for (int i = 0; i < items.length(); ++i) {
                char chr = items.charAt(i);
                if (chr == '[') {
                    ++brackets;
                    continue;
                }
                if (chr == ']') {
                    if (brackets <= 0) continue;
                    --brackets;
                    continue;
                }
                if (brackets != 0 || chr != '|' && chr != '\u0005') continue;
                super.add(items.substring(start, i));
                start = i + 1;
            }
            if (start < items.length()) {
                super.add(items.substring(start));
            }
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new ElementTag(str));
        }
    }

    public ListTag(String flag, boolean is_flag, List<String> flag_contents) {
        if (is_flag) {
            this.flag = flag;
        }
        for (String it : flag_contents) {
            super.add(it);
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new ElementTag(str));
        }
    }

    public ListTag(ListTag input) {
        this.objectForms = new ArrayList<ObjectTag>(input.objectForms);
        super.ensureCapacity(input.size());
        for (String str : input) {
            super.add(str);
        }
    }

    public ListTag(List<String> items) {
        if (items != null) {
            for (String it : items) {
                super.add(it);
            }
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new ElementTag(str));
        }
    }

    public ListTag(Set<?> items) {
        this.objectForms = new ArrayList();
        if (items != null) {
            for (Object o : items) {
                String strd = o.toString();
                super.add(strd);
                if (o instanceof ObjectTag) {
                    this.objectForms.add((ObjectTag)o);
                    continue;
                }
                this.objectForms.add(new ElementTag(strd));
            }
        }
    }

    public ListTag(List<String> items, String prefix) {
        for (String element : items) {
            super.add(prefix + element);
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new ElementTag(str));
        }
    }

    public ListTag addObjects(List<ObjectTag> ObjectTags) {
        for (ObjectTag obj : ObjectTags) {
            this.addObject(obj);
        }
        return this;
    }

    public String[] toArray() {
        return this.toArray(this.size());
    }

    public String[] toArray(int arraySize) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this) {
            list.add(string);
        }
        return list.toArray(new String[arraySize]);
    }

    public boolean containsObjectsFrom(Class<? extends ObjectTag> dClass) {
        for (ObjectTag testable : this.objectForms) {
            if (!CoreUtilities.canPossiblyBeType(testable, dClass)) continue;
            return true;
        }
        return false;
    }

    public List<String> filter(Enum[] values) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this) {
            for (Enum value : values) {
                if (!value.name().equalsIgnoreCase(string)) continue;
                list.add(string);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass) {
        return this.filter(dClass, DenizenCore.getImplementation().getTagContext(null));
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, ScriptEntry entry) {
        return this.filter(dClass, entry == null ? DenizenCore.getImplementation().getTagContext(null) : entry.entryData.getTagContext());
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, Debuggable debugger) {
        TagContext context = DenizenCore.getImplementation().getTagContext(null);
        context.debug = debugger.shouldDebug();
        return this.filter(dClass, context);
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, TagContext context) {
        ArrayList<T> results = new ArrayList<T>();
        for (ObjectTag obj : this.objectForms) {
            try {
                T object;
                if (!CoreUtilities.canPossiblyBeType(obj, dClass) || (object = CoreUtilities.asType(obj, dClass, context)) == null) continue;
                results.add(object);
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
        return results;
    }

    @Override
    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ListTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isEmpty()) {
            return "li@";
        }
        StringBuilder debugText = new StringBuilder();
        debugText.append("li@");
        for (ObjectTag item : this.objectForms) {
            debugText.append(item.debuggable()).append(" <G>|<Y> ");
        }
        return debugText.substring(0, debugText.length() - " <G>|<Y> ".length());
    }

    @Override
    public boolean isUnique() {
        return this.flag != null;
    }

    @Override
    public String getObjectType() {
        return "List";
    }

    @Override
    public String identify() {
        if (this.flag != null) {
            if (this.size() == 1) {
                return DenizenCore.getImplementation().getLastEntryFromFlag(this.flag);
            }
            StringBuilder dScriptArg = new StringBuilder();
            for (String item : this) {
                dScriptArg.append(item).append('|');
            }
            return dScriptArg.substring(0, dScriptArg.length() - 1);
        }
        return this.identifyList();
    }

    public String identifyList() {
        if (this.isEmpty()) {
            return "li@";
        }
        StringBuilder dScriptArg = new StringBuilder();
        dScriptArg.append("li@");
        for (String item : this) {
            dScriptArg.append(item).append('|');
        }
        return dScriptArg.substring(0, dScriptArg.length() - 1);
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public static void registerTags() {
        ListTag.registerTag("combine", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag list = (ListTag)object;
                ListTag output = new ListTag();
                for (ObjectTag obj : list.objectForms) {
                    output.addObjects(ListTag.getListFor((ObjectTag)obj).objectForms);
                }
                return output.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("space_separated", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((ListTag)object).isEmpty()) {
                    return new ElementTag("").getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(ListTag.parseString((ListTag)object, " ")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("as_string", registeredObjectTags.get("space_separated"));
        ListTag.registerTag("asstring", registeredObjectTags.get("space_separated"));
        ListTag.registerTag("separated_by", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag list = (ListTag)object;
                if (list.isEmpty()) {
                    return new ElementTag("").getObjectAttribute(attribute.fulfill(1));
                }
                String input = attribute.getContext(1);
                return new ElementTag(ListTag.parseString(list, input)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("comma_separated", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((ListTag)object).isEmpty()) {
                    return new ElementTag("").getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(ListTag.parseString((ListTag)object, ", ")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("ascslist", registeredObjectTags.get("comma_separated"));
        ListTag.registerTag("as_cslist", registeredObjectTags.get("comma_separated"));
        ListTag.registerTag("unseparated", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((ListTag)object).isEmpty()) {
                    return new ElementTag("").getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(ListTag.parseString((ListTag)object, "")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("get_sub_items", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                int index = -1;
                if (ArgumentHelper.matchesInteger(attribute.getContext(1))) {
                    index = attribute.getIntContext(1) - 1;
                }
                attribute.fulfill(1);
                String split = "/";
                if (attribute.startsWith("split_by")) {
                    if (attribute.hasContext(1) && attribute.getContext(1).length() > 0) {
                        split = attribute.getContext(1);
                    }
                    attribute.fulfill(1);
                }
                if (index < 0) {
                    return null;
                }
                ListTag sub_list = new ListTag();
                for (String item : (ListTag)object) {
                    String[] strings = item.split(Pattern.quote(split));
                    if (strings.length > index) {
                        sub_list.add(strings[index]);
                        continue;
                    }
                    sub_list.add("null");
                }
                return sub_list.getObjectAttribute(attribute);
            }
        });
        ListTag.registerTag("map_get", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((ListTag)object).isEmpty()) {
                    return new ElementTag("").getObjectAttribute(attribute.fulfill(1));
                }
                String input = attribute.getContext(1);
                attribute.fulfill(1);
                String split = "/";
                if (attribute.startsWith("split_by")) {
                    if (attribute.hasContext(1) && attribute.getContext(1).length() > 0) {
                        split = attribute.getContext(1);
                    }
                    attribute.fulfill(1);
                }
                for (String item : (ListTag)object) {
                    String[] strings = item.split(Pattern.quote(split), 2);
                    if (strings.length <= 1 || !strings[0].equalsIgnoreCase(input)) continue;
                    return new ElementTag(strings[1]).getObjectAttribute(attribute);
                }
                return null;
            }
        });
        ListTag.registerTag("map_find_key", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                String input = attribute.getContext(1);
                attribute.fulfill(1);
                String split = "/";
                if (attribute.startsWith("split_by")) {
                    if (attribute.hasContext(1) && attribute.getContext(1).length() > 0) {
                        split = attribute.getContext(1);
                    }
                    attribute.fulfill(1);
                }
                for (String item : (ListTag)object) {
                    String[] strings = item.split(Pattern.quote(split), 2);
                    if (strings.length <= 1 || !strings[1].equalsIgnoreCase(input)) continue;
                    return new ElementTag(strings[0]).getObjectAttribute(attribute);
                }
                return null;
            }
        });
        ListTag.registerTag("size", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ListTag)object).size()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("is_empty", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ListTag)object).isEmpty()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("insert", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.insert[...] must have a value.");
                    return null;
                }
                ListTag items = ListTag.getListFor(attribute.getContextObject(1));
                if ((attribute = attribute.fulfill(1)).startsWith("at") && attribute.hasContext(1)) {
                    ListTag result = new ListTag((ListTag)object);
                    int index = new ElementTag(attribute.getContext(1)).asInt() - 1;
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > result.size()) {
                        index = result.size();
                    }
                    for (int i = 0; i < items.size(); ++i) {
                        result.addObject(index + i, items.getObject(i));
                    }
                    return result.getObjectAttribute(attribute.fulfill(1));
                }
                Debug.echoError("The tag ListTag.insert[...] must be followed by .at[#]!");
                return null;
            }
        });
        ListTag.registerTag("set", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.set[...] must have a value.");
                    return null;
                }
                if (((ListTag)object).isEmpty()) {
                    return null;
                }
                ListTag items = ListTag.getListFor(attribute.getContextObject(1));
                if ((attribute = attribute.fulfill(1)).startsWith("at") && attribute.hasContext(1)) {
                    ListTag result = new ListTag((ListTag)object);
                    int index = ArgumentHelper.getIntegerFrom(attribute.getContext(1)) - 1;
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > result.size() - 1) {
                        index = result.size() - 1;
                    }
                    result.remove(index);
                    for (int i = 0; i < items.size(); ++i) {
                        result.addObject(index + i, items.objectForms.get(i));
                    }
                    return result.getObjectAttribute(attribute.fulfill(1));
                }
                Debug.echoError("The tag ListTag.set[...] must be followed by .at[#]!");
                return null;
            }
        });
        ListTag.registerTag("include", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.include[...] must have a value.");
                    return null;
                }
                ListTag copy = new ListTag((ListTag)object);
                copy.addAll(ListTag.getListFor(attribute.getContextObject(1)));
                return copy.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("exclude", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.exclude[...] must have a value.");
                    return null;
                }
                ListTag exclusions = ListTag.getListFor(attribute.getContextObject(1));
                ListTag copy = new ListTag((ListTag)object);
                for (String exclusion : exclusions) {
                    for (int i = 0; i < copy.size(); ++i) {
                        if (!((String)copy.get(i)).equalsIgnoreCase(exclusion)) continue;
                        copy.remove(i--);
                    }
                }
                return copy.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("remove", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.remove[#] must have a value.");
                    return null;
                }
                ListTag indices = ListTag.getListFor(attribute.getContextObject(1));
                ListTag copy = new ListTag((ListTag)object);
                for (String index : indices) {
                    int remove = index.equalsIgnoreCase("last") ? copy.size() - 1 : (index.equalsIgnoreCase("first") ? 0 : new ElementTag(index).asInt() - 1);
                    if (remove < 0 || remove >= copy.size()) continue;
                    copy.set(remove, "\u0000");
                }
                for (int i = 0; i < copy.size(); ++i) {
                    if (!((String)copy.get(i)).equals("\u0000")) continue;
                    copy.remove(i--);
                }
                return copy.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("replace", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.replace[...] must have a value.");
                    return null;
                }
                String replace = attribute.getContext(1);
                ObjectTag replacement = null;
                attribute.fulfill(1);
                if (attribute.startsWith("with") && attribute.hasContext(1)) {
                    replacement = attribute.getContextObject(1);
                    attribute.fulfill(1);
                }
                ListTag obj = (ListTag)object;
                ListTag list = new ListTag();
                if (replace.startsWith("regex:")) {
                    String regex = replace.substring("regex:".length());
                    Pattern tempPat = Pattern.compile(regex);
                    for (int i = 0; i < obj.size(); ++i) {
                        if (tempPat.matcher((CharSequence)obj.get(i)).matches()) {
                            if (replacement == null) continue;
                            list.addObject(replacement);
                            continue;
                        }
                        list.addObject(obj.getObject(i));
                    }
                } else {
                    String lower = CoreUtilities.toLowerCase(replace);
                    for (int i = 0; i < obj.size(); ++i) {
                        if (CoreUtilities.toLowerCase((String)obj.get(i)).equals(lower)) {
                            if (replacement == null) continue;
                            list.addObject(replacement);
                            continue;
                        }
                        list.addObject(obj.getObject(i));
                    }
                }
                return list.getObjectAttribute(attribute);
            }
        });
        ListTag.registerTag("reverse", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ArrayList<ObjectTag> objs = new ArrayList<ObjectTag>(((ListTag)object).objectForms);
                Collections.reverse(objs);
                return new ListTag((Collection<? extends ObjectTag>)objs).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("deduplicate", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag obj = (ListTag)object;
                ListTag list = new ListTag();
                int size = obj.size();
                for (int i = 0; i < size; ++i) {
                    String entry = (String)obj.get(i);
                    boolean duplicate = false;
                    for (int x = 0; x < i; ++x) {
                        if (!((String)obj.get(x)).equalsIgnoreCase(entry)) continue;
                        duplicate = true;
                        break;
                    }
                    if (duplicate) continue;
                    list.addObject(obj.objectForms.get(i));
                }
                return list.getObjectAttribute(attribute.fulfill(1));
            }
        });
        TagRunnable.ObjectForm getRunnable = new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.get[...] must have a value.");
                    return null;
                }
                ListTag list = (ListTag)object;
                if (list.isEmpty()) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Can't get from an empty list.");
                    }
                    return null;
                }
                ListTag indices = ListTag.getListFor(attribute.getContextObject(1));
                if (indices.size() > 1) {
                    ListTag results = new ListTag();
                    for (String index : indices) {
                        int ind = ArgumentHelper.getIntegerFrom(index);
                        if (ind <= 0 || ind > list.size()) continue;
                        results.add((String)list.get(ind - 1));
                    }
                    return results.getObjectAttribute(attribute.fulfill(1));
                }
                if (indices.size() > 0) {
                    int index = ArgumentHelper.getIntegerFrom((String)indices.get(0)) - 1;
                    if (index >= list.size()) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("Invalid list.get index.");
                        }
                        return null;
                    }
                    if (index < 0) {
                        index = 0;
                    }
                    if ((attribute = attribute.fulfill(1)).startsWith("to") && attribute.hasContext(1)) {
                        int index2 = attribute.getIntContext(1) - 1;
                        if (index2 >= list.size()) {
                            index2 = list.size() - 1;
                        }
                        if (index2 < 0) {
                            index2 = 0;
                        }
                        ListTag newList = new ListTag();
                        for (int i = index; i <= index2; ++i) {
                            newList.addObject(list.objectForms.get(i));
                        }
                        return newList.getObjectAttribute(attribute.fulfill(1));
                    }
                    return CoreUtilities.autoAttribTyped(list.objectForms.get(index), attribute);
                }
                return null;
            }
        };
        ListTag.registerTag("get", getRunnable.clone());
        ListTag.registerTag("", getRunnable.clone());
        ListTag.registerTag("find_all_partial", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.find_all_partial[...] must have a value.");
                    return null;
                }
                ListTag list = (ListTag)object;
                String test = attribute.getContext(1).toUpperCase();
                ListTag positions = new ListTag();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).toUpperCase().contains(test)) continue;
                    positions.add(String.valueOf(i + 1));
                }
                return positions.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("find_all", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.find_all[...] must have a value.");
                    return null;
                }
                ListTag list = (ListTag)object;
                ListTag positions = new ListTag();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(attribute.getContext(1))) continue;
                    positions.add(String.valueOf(i + 1));
                }
                return positions.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("find_partial", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.find_partial[...] must have a value.");
                    return null;
                }
                ListTag list = (ListTag)object;
                String test = attribute.getContext(1).toUpperCase();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).toUpperCase().contains(test)) continue;
                    return new ElementTag(i + 1).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(-1).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("find", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.find[...] must have a value.");
                    return null;
                }
                ListTag list = (ListTag)object;
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(attribute.getContext(1))) continue;
                    return new ElementTag(i + 1).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(-1).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("count", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.count[...] must have a value.");
                    return null;
                }
                ListTag list = (ListTag)object;
                String element = attribute.getContext(1);
                int count = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(element)) continue;
                    ++count;
                }
                return new ElementTag(count).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("sum", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag list = (ListTag)object;
                double sum = 0.0;
                for (String entry : list) {
                    sum += ArgumentHelper.getDoubleFrom(entry);
                }
                return new ElementTag(sum).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("average", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag list = (ListTag)object;
                if (list.isEmpty()) {
                    return new ElementTag(0).getObjectAttribute(attribute.fulfill(1));
                }
                double sum = 0.0;
                for (String entry : list) {
                    sum += ArgumentHelper.getDoubleFrom(entry);
                }
                return new ElementTag(sum / (double)list.size()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("first", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag list = (ListTag)object;
                if (list.isEmpty()) {
                    return null;
                }
                return CoreUtilities.autoAttribTyped(list.objectForms.get(0), attribute.fulfill(1));
            }
        });
        ListTag.registerTag("last", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag list = (ListTag)object;
                if (list.isEmpty()) {
                    return null;
                }
                return CoreUtilities.autoAttribTyped(list.objectForms.get(list.size() - 1), attribute.fulfill(1));
            }
        });
        ListTag.registerTag("lowest", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag list = (ListTag)object;
                BigDecimal lowest = null;
                for (String str : list) {
                    if (!ArgumentHelper.matchesDouble(str)) continue;
                    BigDecimal val = new ElementTag(str).asBigDecimal();
                    if (lowest != null && lowest.compareTo(val) <= 0) continue;
                    lowest = val;
                }
                if (lowest == null) {
                    return null;
                }
                return new ElementTag(lowest).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("highest", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag list = (ListTag)object;
                BigDecimal highest = null;
                for (String str : list) {
                    if (!ArgumentHelper.matchesDouble(str)) continue;
                    BigDecimal val = new ElementTag(str).asBigDecimal();
                    if (highest != null && highest.compareTo(val) >= 0) continue;
                    highest = val;
                }
                if (highest == null) {
                    return null;
                }
                return new ElementTag(highest).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("numerical", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ArrayList<String> sortable = new ArrayList<String>((ListTag)object);
                Collections.sort(sortable, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        double value = new ElementTag(o1).asDouble() - new ElementTag(o2).asDouble();
                        if (value == 0.0) {
                            return 0;
                        }
                        if (value > 0.0) {
                            return 1;
                        }
                        return -1;
                    }
                });
                return new ListTag((List<String>)sortable).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("alphanumeric", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ArrayList<String> sortable = new ArrayList<String>((ListTag)object);
                Collections.sort(sortable, new NaturalOrderComparator());
                return new ListTag((List<String>)sortable).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("alphabetical", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ArrayList<String> sortable = new ArrayList<String>((ListTag)object);
                Collections.sort(sortable, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                return new ListTag((List<String>)sortable).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("sort_by_number", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(final Attribute attribute, ObjectTag object) {
                ListTag newlist = new ListTag((ListTag)object);
                try {
                    Collections.sort(newlist.objectForms, new Comparator<ObjectTag>(){

                        @Override
                        public int compare(ObjectTag o1, ObjectTag o2) {
                            double r2;
                            ObjectTag or1 = CoreUtilities.autoAttribTyped(o1, new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context));
                            ObjectTag or2 = CoreUtilities.autoAttribTyped(o2, new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context));
                            double r1 = ArgumentHelper.getDoubleFrom(or1.toString());
                            double value = r1 - (r2 = ArgumentHelper.getDoubleFrom(or2.toString()));
                            if (value == 0.0) {
                                return 0;
                            }
                            if (value > 0.0) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    return new ListTag((Collection<? extends ObjectTag>)newlist.objectForms).getObjectAttribute(attribute.fulfill(1));
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                    return newlist.getObjectAttribute(attribute.fulfill(1));
                }
            }
        });
        ListTag.registerTag("sort", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag obj = new ListTag((ListTag)object);
                final ProcedureScriptContainer script = (ProcedureScriptContainer)ScriptTag.valueOf(attribute.getContext(1)).getContainer();
                if (script == null) {
                    Debug.echoError("'" + attribute.getContext(1) + "' is not a valid procedure script!");
                    return obj.getObjectAttribute(attribute.fulfill(1));
                }
                final ScriptEntry entry = attribute.getScriptEntry();
                attribute = attribute.fulfill(1);
                ListTag context = new ListTag();
                if (attribute.startsWith("context")) {
                    context = ListTag.getListFor(attribute.getContextObject(1));
                    attribute = attribute.fulfill(1);
                }
                final ListTag context_send = context;
                ArrayList<String> list = new ArrayList<String>(obj);
                try {
                    Collections.sort(list, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            List<ScriptEntry> entries = script.getBaseEntries(entry == null ? DenizenCore.getImplementation().getEmptyScriptEntryData() : entry.entryData.clone());
                            if (entries.isEmpty()) {
                                return 0;
                            }
                            InstantQueue queue = new InstantQueue("LISTTAG_SORT");
                            queue.addEntries(entries);
                            int x = 1;
                            ListTag definitions = new ListTag();
                            definitions.add(o1);
                            definitions.add(o2);
                            definitions.addAll(context_send);
                            String[] definition_names = null;
                            try {
                                definition_names = script.getString("definitions").split("\\|");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            for (String definition : definitions) {
                                String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                                queue.addDefinition(name, definition);
                                Debug.echoDebug((Debuggable)entries.get(0), "Adding definition %" + name + "% as " + definition);
                                ++x;
                            }
                            queue.start();
                            int res = 0;
                            if (queue.determinations != null && queue.determinations.size() > 0) {
                                res = new ElementTag((String)queue.determinations.get(0)).asInt();
                            }
                            if (res < 0) {
                                return -1;
                            }
                            if (res > 0) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                }
                catch (Exception e) {
                    Debug.echoError("list.sort[...] tag failed - procedure returned unreasonable response - internal error: " + e.getMessage());
                }
                return new ListTag((List<String>)list).getObjectAttribute(attribute);
            }
        });
        ListTag.registerTag("filter", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                String tag = attribute.getContext(1);
                boolean defaultValue = tag.endsWith("||true");
                if (defaultValue) {
                    tag = tag.substring(0, tag.length() - "||true".length());
                }
                ListTag newlist = new ListTag();
                try {
                    for (ObjectTag obj : ((ListTag)object).objectForms) {
                        Attribute tempAttrib = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
                        tempAttrib.setHadAlternative(true);
                        ObjectTag objs = CoreUtilities.autoAttribTyped(obj, tempAttrib);
                        if (!(objs == null ? defaultValue : CoreUtilities.toLowerCase(objs.toString()).equals("true"))) continue;
                        newlist.addObject(obj);
                    }
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                }
                return newlist.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("parse", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag newlist = new ListTag();
                String tag = attribute.getContext(1);
                String defaultValue = "null";
                boolean fallback = false;
                if (tag.contains("||")) {
                    int marks = 0;
                    int lengthLimit = tag.length() - 1;
                    for (int i = 0; i < lengthLimit; ++i) {
                        char c = tag.charAt(i);
                        if (c == '<') {
                            ++marks;
                            continue;
                        }
                        if (c == '>') {
                            --marks;
                            continue;
                        }
                        if (marks != 0 || c != '|' || tag.charAt(i + 1) != '|') continue;
                        fallback = true;
                        defaultValue = tag.substring(i + 2);
                        tag = tag.substring(0, i);
                        break;
                    }
                }
                try {
                    for (ObjectTag obj : ((ListTag)object).objectForms) {
                        Attribute tempAttrib = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
                        tempAttrib.setHadAlternative(attribute.hasAlternative() || fallback);
                        ObjectTag objs = CoreUtilities.autoAttribTyped(obj, tempAttrib);
                        if (objs == null) {
                            objs = new ElementTag(defaultValue);
                        }
                        newlist.addObject(objs);
                    }
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                }
                return newlist.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("pad_left", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.pad_left[...] must have a value.");
                    return null;
                }
                ObjectTag with = new ElementTag("");
                int length = attribute.getIntContext(1);
                if ((attribute = attribute.fulfill(1)).startsWith("with") && attribute.hasContext(1)) {
                    with = attribute.getContextObject(1);
                    attribute = attribute.fulfill(1);
                }
                ListTag newList = new ListTag((ListTag)object);
                while (newList.size() < length) {
                    newList.addObject(with);
                }
                return newList.getObjectAttribute(attribute);
            }
        });
        ListTag.registerTag("pad_right", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.pad_right[...] must have a value.");
                    return null;
                }
                ObjectTag with = new ElementTag("");
                int length = attribute.getIntContext(1);
                if ((attribute = attribute.fulfill(1)).startsWith("with") && attribute.hasContext(1)) {
                    with = attribute.getContextObject(1);
                    attribute = attribute.fulfill(1);
                }
                ListTag newList = new ListTag((ListTag)object);
                while (newList.size() < length) {
                    newList.addObject(with);
                }
                return newList.getObjectAttribute(attribute);
            }
        });
        ListTag.registerTag("escape_contents", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag escaped = new ListTag();
                for (String entry : (ListTag)object) {
                    escaped.add(EscapeTagBase.escape(entry));
                }
                return escaped.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("unescape_contents", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag escaped = new ListTag();
                for (String entry : (ListTag)object) {
                    escaped.add(EscapeTagBase.unEscape(entry));
                }
                return escaped.getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("contains_any_case_sensitive", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.contains_any_case_sensitive[...] must have a value.");
                    return null;
                }
                ListTag list = ListTag.getListFor(attribute.getContextObject(1));
                boolean state = false;
                block0: for (String element : (ListTag)object) {
                    for (String sub_element : list) {
                        if (!element.equals(sub_element)) continue;
                        state = true;
                        break block0;
                    }
                }
                return new ElementTag(state).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("contains_any", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.contains_any[...] must have a value.");
                    return null;
                }
                ListTag list = ListTag.getListFor(attribute.getContextObject(1));
                boolean state = false;
                block0: for (String element : (ListTag)object) {
                    for (String sub_element : list) {
                        if (!element.equalsIgnoreCase(sub_element)) continue;
                        state = true;
                        break block0;
                    }
                }
                return new ElementTag(state).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("contains_case_sensitive", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.contains_case_sensitive[...] must have a value.");
                    return null;
                }
                boolean state = false;
                for (String element : (ListTag)object) {
                    if (!element.equals(attribute.getContext(1))) continue;
                    state = true;
                    break;
                }
                return new ElementTag(state).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("contains", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ListTag.contains[...] must have a value.");
                    return null;
                }
                ListTag needed = ListTag.getListFor(attribute.getContextObject(1));
                int gotten = 0;
                block0: for (String check : needed) {
                    for (String element : (ListTag)object) {
                        if (!element.equalsIgnoreCase(check)) continue;
                        ++gotten;
                        continue block0;
                    }
                }
                return new ElementTag(gotten == needed.size() && gotten > 0).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("random", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag obj = (ListTag)object;
                if (obj.isEmpty()) {
                    return null;
                }
                if (attribute.hasContext(1)) {
                    int count = Integer.valueOf(attribute.getContext(1));
                    ArrayList<ObjectTag> available = new ArrayList<ObjectTag>();
                    available.addAll(obj.objectForms);
                    ListTag toReturn = new ListTag();
                    for (int times = 0; !available.isEmpty() && times < count; ++times) {
                        int random = CoreUtilities.getRandom().nextInt(available.size());
                        toReturn.addObject((ObjectTag)available.get(random));
                        available.remove(random);
                    }
                    return toReturn.getObjectAttribute(attribute.fulfill(1));
                }
                return CoreUtilities.autoAttribTyped(obj.objectForms.get(CoreUtilities.getRandom().nextInt(obj.size())), attribute.fulfill(1));
            }
        });
        ListTag.registerTag("closest_to", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(CoreUtilities.getClosestOption((ListTag)object, attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        ListTag.registerTag("type", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag("List").getObjectAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredObjectTags.put(name, runnable);
    }

    private static String parseString(ListTag obj, String spacer) {
        StringBuilder dScriptArg = new StringBuilder();
        for (String item : obj) {
            dScriptArg.append(item);
            dScriptArg.append(spacer);
        }
        return dScriptArg.toString().substring(0, dScriptArg.length() - spacer.length());
    }

    @Override
    public String getAttribute(Attribute attribute) {
        return CoreUtilities.stringifyNullPass(this.getObjectAttribute(attribute));
    }

    @Override
    public <T extends ObjectTag> T asObjectType(Class<T> type, TagContext context) {
        return null;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        int index;
        if (attribute == null) {
            return null;
        }
        if (attribute.isComplete()) {
            return this;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable.ObjectForm otr = registeredObjectTags.get(attrLow);
        if (otr != null) {
            if (!otr.name.equals(attrLow)) {
                Debug.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + otr.name + "': '" + attrLow + "'.");
            }
            return otr.run(attribute, this);
        }
        if (Debug.verbose) {
            Debug.log("ListTag alternate attribute " + attrLow);
        }
        if (ArgumentHelper.matchesInteger(attrLow) && (index = ArgumentHelper.getIntegerFrom(attrLow)) != 0) {
            if (index < 1 || index > this.size()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("ListTag index " + index + " is out of range");
                }
                attribute.fulfill(1);
                return null;
            }
            return this.getObject(index - 1).getObjectAttribute(attribute.fulfill(1));
        }
        if (this.flag != null && (attribute.startsWith("as_list") || attribute.startsWith("aslist"))) {
            return new ListTag(this).getObjectAttribute(attribute.fulfill(1));
        }
        ObjectTag returned = CoreUtilities.autoPropertyTagObject(this, attribute);
        if (returned != null) {
            return returned;
        }
        return this.flag != null ? new ElementTag(DenizenCore.getImplementation().getLastEntryFromFlag(this.flag)).getObjectAttribute(attribute) : new ElementTag(this.identifyList()).getObjectAttribute(attribute);
    }
}

