/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.queue.IfCommand;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.RepeatingSchedulable;
import java.util.ArrayList;
import java.util.List;

public class WaitUntilCommand
extends AbstractCommand
implements Holdable {
    @Override
    public void onEnable() {
        this.setBraced();
        this.setParseArgs(false);
        this.forceHold = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        scriptEntry.addObject("comparisons", scriptEntry.getArguments());
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        final List comparisons = (List)scriptEntry.getObject("comparisons");
        boolean run = new IfCommand.ArgComparer().compare(new ArrayList(comparisons), scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("run_first_check", run));
        }
        if (run) {
            scriptEntry.setFinished(true);
            return;
        }
        final RepeatingSchedulable schedulable = new RepeatingSchedulable(null, scriptEntry.getResidingQueue() instanceof TimedQueue ? (float)((TimedQueue)scriptEntry.getResidingQueue()).getSpeed().getSeconds() : 0.05f);
        schedulable.run = new Runnable(){
            public int counter = 0;

            @Override
            public void run() {
                ++this.counter;
                if (new IfCommand.ArgComparer().compare(new ArrayList(comparisons), scriptEntry)) {
                    Debug.echoDebug((Debuggable)scriptEntry, "WaitUntil completed after " + this.counter + " re-checks.");
                    scriptEntry.setFinished(true);
                    schedulable.cancel();
                }
            }
        };
        DenizenCore.schedule(schedulable);
    }
}

