/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.queues;

import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.CommandExecuter;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.Delayable;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class ScriptEngine {
    private final CommandExecuter commandExecuter = new CommandExecuter();

    boolean shouldHold(ScriptQueue scriptQueue) {
        if (scriptQueue instanceof Delayable && ((Delayable)((Object)scriptQueue)).isPaused()) {
            return true;
        }
        if (scriptQueue.getLastEntryExecuted() != null && scriptQueue.getLastEntryExecuted().shouldWaitFor()) {
            if (!(scriptQueue instanceof Delayable)) {
                Debug.echoDebug((Debuggable)scriptQueue.getLastEntryExecuted(), "Forcing queue " + scriptQueue.id + " into a timed queue...");
                scriptQueue.forceToTimed(null);
                return true;
            }
            return true;
        }
        return false;
    }

    public void revolveOnceForce(ScriptQueue scriptQueue) {
        ScriptEntry scriptEntry = scriptQueue.getNext();
        if (scriptEntry == null) {
            return;
        }
        scriptEntry.setSendingQueue(scriptQueue);
        try {
            this.getScriptExecuter().execute(scriptEntry);
        }
        catch (Throwable e) {
            Debug.echoError(scriptEntry.getResidingQueue(), "An exception has been called with this command (while revolving the queue forcefully)!");
            Debug.echoError(scriptEntry.getResidingQueue(), e);
        }
        scriptQueue.setLastEntryExecuted(scriptEntry);
    }

    public void revolve(ScriptQueue scriptQueue) {
        if (this.shouldHold(scriptQueue)) {
            return;
        }
        ScriptEntry scriptEntry = scriptQueue.getNext();
        while (scriptEntry != null) {
            scriptEntry.setSendingQueue(scriptQueue);
            scriptQueue.setLastEntryExecuted(scriptEntry);
            try {
                this.getScriptExecuter().execute(scriptEntry);
            }
            catch (Throwable e) {
                Debug.echoError(scriptEntry.getResidingQueue(), "Woah! An exception has been called with this command (while revolving the queue)!");
                Debug.echoError(scriptEntry.getResidingQueue(), e);
            }
            if (scriptQueue instanceof Delayable) {
                if (((Delayable)((Object)scriptQueue)).isDelayed() || ((Delayable)((Object)scriptQueue)).isPaused() || !((Delayable)((Object)scriptQueue)).isInstantSpeed() && !scriptEntry.isInstant()) break;
                if (this.shouldHold(scriptQueue)) {
                    return;
                }
                scriptEntry = scriptQueue.getNext();
                continue;
            }
            if (!scriptEntry.isInstant()) break;
            if (this.shouldHold(scriptQueue)) {
                return;
            }
            scriptEntry = scriptQueue.getNext();
        }
    }

    public CommandExecuter getScriptExecuter() {
        return this.commandExecuter;
    }
}

