/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags.core;

import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class ScriptTagBase {
    public ScriptTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                ScriptTagBase.this.scriptTags(event);
            }
        }, "script", "s");
    }

    public void scriptTags(ReplaceableTagEvent event) {
        if (!event.matches("script", "s") || event.replaced()) {
            return;
        }
        if (event.matches("s")) {
            Deprecations.scriptShorthand.warn(event.getScriptEntry());
        }
        ScriptTag script = null;
        if (event.hasNameContext()) {
            if (!ScriptTag.matches(event.getNameContext())) {
                if (!event.hasAlternative()) {
                    Debug.echoError("Script '" + event.getNameContext() + "' does not exist.");
                }
                return;
            }
            script = ScriptTag.valueOf(event.getNameContext(), event.getAttributes().context);
        } else if (event.getScript() != null) {
            script = event.getScript();
        } else {
            if (event.getScriptEntry() == null) {
                if (!event.hasAlternative()) {
                    Debug.echoError("No applicable script for <script> tag.");
                }
                return;
            }
            if (event.getScriptEntry().getScript() != null) {
                script = event.getScriptEntry().getScript();
            } else if (event.getScriptEntry().hasObject("script")) {
                script = (ScriptTag)event.getScriptEntry().getObject("script");
            }
        }
        Attribute attribute = event.getAttributes();
        if (script == null) {
            if (!event.hasAlternative()) {
                Debug.echoError("No applicable script for <script> tag.");
            }
            return;
        }
        event.setReplacedObject(CoreUtilities.autoAttrib(script, attribute.fulfill(1)));
    }
}

