/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.HorseJumpEvent;

public class HorseJumpsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static HorseJumpsScriptEvent instance;
    public EntityTag entity;
    public ElementTag color;
    public ElementTag variant;
    public Float power;
    public HorseJumpEvent event;

    public HorseJumpsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.equals("horse jumps") || lower.endsWith("jumps");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String tamed;
        String arg1 = path.eventArgLowerAt(0);
        String arg2 = path.eventArgLowerAt(1);
        String string = tamed = arg2.equals("jumps") ? arg1 : arg2;
        if (!this.tryEntity(this.entity, tamed) || !tamed.equals(CoreUtilities.toLowerCase(this.variant.toString()))) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("jumps") && !arg1.equals(CoreUtilities.toLowerCase(this.color.toString()))) {
            return false;
        }
        return this.runInCheck(path, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "HorseJumps";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isFloat()) {
            this.power = Float.valueOf(((ElementTag)determinationObj).asFloat());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("color")) {
            return this.color;
        }
        if (name.equals("variant")) {
            return this.variant;
        }
        if (name.equals("power")) {
            return new ElementTag(this.power.floatValue());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onHorseJumps(HorseJumpEvent event) {
        if (event.getEntity() instanceof Horse) {
            this.entity = new EntityTag((Entity)event.getEntity());
            this.color = new ElementTag(((Horse)event.getEntity()).getColor().name());
            this.variant = new ElementTag(event.getEntity().getVariant().name());
            this.power = Float.valueOf(event.getPower());
            this.event = event;
            this.fire((Event)event);
            event.setPower(this.power.floatValue());
        }
    }
}

