/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;

public class VehicleMoveScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VehicleMoveScriptEvent instance;
    public EntityTag vehicle;
    public LocationTag from;
    public LocationTag to;
    public VehicleMoveEvent event;

    public VehicleMoveScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.xthArgEquals(1, lower, "moves");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.vehicle, path.eventArgLowerAt(0))) {
            return false;
        }
        return this.runInCheck(path, this.vehicle.getLocation());
    }

    @Override
    public String getName() {
        return "VehicleMoves";
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("from")) {
            return this.from;
        }
        if (name.equals("to")) {
            return this.to;
        }
        if (name.equals("vehicle")) {
            return this.vehicle;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        this.to = new LocationTag(event.getTo());
        this.from = new LocationTag(event.getFrom());
        this.vehicle = new EntityTag((Entity)event.getVehicle());
        this.event = event;
        this.fire((Event)event);
    }
}

