/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class BiomeEnterExitScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BiomeEnterExitScriptEvent instance;
    public LocationTag from;
    public LocationTag to;
    public BiomeTag old_biome;
    public BiomeTag new_biome;
    public PlayerMoveEvent event;

    public BiomeEnterExitScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player enters") || path.eventLower.startsWith("player exits");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        BiomeTag biome;
        String biome_test = path.eventArgAt(2);
        String direction = path.eventArgAt(1);
        if (!this.runInCheck(path, this.from) && !this.runInCheck(path, this.to)) {
            return false;
        }
        BiomeTag biomeTag = direction.equals("enters") ? this.new_biome : (biome = direction.equals("exits") ? this.old_biome : null);
        if (biome == null) {
            return false;
        }
        return biome_test.equals("biome") || biome_test.equals(CoreUtilities.toLowerCase(biome.getBiome().getName()));
    }

    @Override
    public String getName() {
        return "BiomeEnterExit";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event != null ? EntityTag.getPlayerFrom((Entity)this.event.getPlayer()) : null, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("to")) {
            return this.to;
        }
        if (name.equals("from")) {
            return this.from;
        }
        if (name.equals("old_biome")) {
            return this.old_biome;
        }
        if (name.equals("new_biome")) {
            return this.new_biome;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerEntersExitsBiome(PlayerMoveEvent event) {
        this.from = new LocationTag(event.getFrom());
        this.to = new LocationTag(event.getTo());
        this.old_biome = new BiomeTag(this.from.getBlock().getBiome());
        this.new_biome = new BiomeTag(this.to.getBlock().getBiome());
        if (this.old_biome.identify().equals(this.new_biome.identify())) {
            return;
        }
        this.event = event;
        this.fire((Event)event);
    }
}

