/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;

public class PlayerTabCompleteScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerTabCompleteScriptEvent instance;
    public TabCompleteEvent event;
    public String buffer;
    public ListTag completions;
    public CommandSender sender;

    public PlayerTabCompleteScriptEvent() {
        instance = this;
    }

    public String getCommand() {
        String cmd;
        String[] args = this.buffer.trim().split(" ");
        String string = cmd = args.length > 0 ? args[0] : "";
        if (this.sender instanceof Player) {
            cmd = cmd.replaceFirst("/", "");
        }
        return cmd;
    }

    public String getCurrentArg() {
        int i = this.buffer.lastIndexOf(32);
        return i > 0 ? this.buffer.substring(i + 1) : this.getCommand();
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("tab complete");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        return true;
    }

    @Override
    public String getName() {
        return "TabComplete";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (determination.length() > 0 && !PlayerTabCompleteScriptEvent.isDefaultDetermination(determinationObj)) {
            this.completions = ListTag.valueOf(determination);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.sender instanceof Player ? new PlayerTag((Player)this.sender) : null, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("buffer")) {
            return new ElementTag(this.buffer);
        }
        if (name.equals("command")) {
            return new ElementTag(this.getCommand());
        }
        if (name.equals("current_arg")) {
            return new ElementTag(this.getCurrentArg());
        }
        if (name.equals("completions")) {
            return this.completions;
        }
        if (name.equals("server")) {
            return new ElementTag(this.sender instanceof ConsoleCommandSender);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent event) {
        this.buffer = event.getBuffer();
        this.completions = new ListTag(event.getCompletions());
        this.sender = event.getSender();
        this.event = event;
        this.fire((Event)event);
        event.setCompletions((List)this.completions);
    }
}

