/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.Paginator;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;

public class ConstantsTrait
extends Trait {
    @Persist(value="", collectionType=ConcurrentHashMap.class)
    private Map<String, String> constants = new HashMap<String, String>();
    private Map<String, String> assignmentConstants = new HashMap<String, String>();
    private String assignment = null;

    public ConstantsTrait() {
        super("constants");
    }

    public String getConstant(String name) {
        this.getAssignmentConstants();
        if (this.constants.containsKey(CoreUtilities.toLowerCase(name))) {
            return TagManager.tag(this.constants.get(CoreUtilities.toLowerCase(name)), new BukkitTagContext(null, DenizenAPI.getDenizenNPC(this.npc), false, null, true, null));
        }
        if (this.getAssignmentConstants().containsKey(CoreUtilities.toLowerCase(name))) {
            return TagManager.tag(this.assignmentConstants.get(CoreUtilities.toLowerCase(name)), new BukkitTagContext(null, DenizenAPI.getDenizenNPC(this.npc), false, null, true, null));
        }
        return null;
    }

    public Map<String, String> getNPCConstants() {
        return this.constants;
    }

    public Map<String, String> getAllConstants() {
        HashMap<String, String> allConstants = new HashMap<String, String>();
        this.getAssignmentConstants().putAll(allConstants);
        this.getNPCConstants().putAll(allConstants);
        return allConstants;
    }

    public void setConstant(String name, String value) {
        this.constants.put(CoreUtilities.toLowerCase(name), value);
    }

    public void removeConstant(String name) {
        if (this.constants.containsKey(CoreUtilities.toLowerCase(name))) {
            this.constants.remove(CoreUtilities.toLowerCase(name));
        }
    }

    public boolean hasNPCConstants() {
        return !this.constants.isEmpty();
    }

    public Map<String, String> getAssignmentConstants() {
        if (this.npc.hasTrait(AssignmentTrait.class) && ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).hasAssignment()) {
            if (this.assignment != null && this.assignment.equalsIgnoreCase(((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).getAssignment().getName())) {
                return this.assignmentConstants;
            }
            return this.rebuildAssignmentConstants();
        }
        return this.assignmentConstants;
    }

    public Map<String, String> rebuildAssignmentConstants() {
        if (!this.npc.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).hasAssignment()) {
            this.assignmentConstants.clear();
            return this.assignmentConstants;
        }
        if (((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).getAssignment() == null) {
            return this.assignmentConstants;
        }
        this.assignment = ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).getAssignment().getName();
        this.assignmentConstants.clear();
        try {
            if (((ScriptContainer)ScriptRegistry.getScriptContainer(this.assignment)).contains("DEFAULT CONSTANTS")) {
                for (StringHolder constant : ((ScriptContainer)ScriptRegistry.getScriptContainer(this.assignment)).getConfigurationSection("DEFAULT CONSTANTS").getKeys(false)) {
                    this.assignmentConstants.put(CoreUtilities.toLowerCase(constant.str), ((ScriptContainer)ScriptRegistry.getScriptContainer(this.assignment)).getString("DEFAULT CONSTANTS." + constant.str.toUpperCase(), ""));
                }
            }
        }
        catch (NullPointerException e) {
            Debug.echoError("Constants in assignment script '" + ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).getAssignment().getName() + "' improperly defined, no constants will be set.");
        }
        return this.assignmentConstants;
    }

    @EventHandler
    public void onScriptsReload(ScriptReloadEvent event) {
        this.rebuildAssignmentConstants();
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        Paginator paginator = new Paginator().header("Constants for " + this.npc.getName());
        paginator.addLine("<e>NPC-specific constants: " + (this.hasNPCConstants() ? "" : "None.") + "");
        if (this.hasNPCConstants()) {
            paginator.addLine("<e>Key: <a>Name  <b>Value");
        }
        for (Map.Entry<String, String> constant : this.constants.entrySet()) {
            paginator.addLine("<a> " + String.valueOf(constant.getKey().charAt(0)).toUpperCase() + constant.getKey().substring(1) + "<b>  " + constant.getValue());
        }
        paginator.addLine("");
        if (this.npc.hasTrait(AssignmentTrait.class) && ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).hasAssignment()) {
            this.getAssignmentConstants();
            paginator.addLine("<e>Constants for assignment '" + this.assignment.toUpperCase() + "':");
            paginator.addLine("<e>Key: <a>Name  <b>Value");
            for (Map.Entry<String, String> constant : this.getAssignmentConstants().entrySet()) {
                if (this.constants.containsKey(constant.getKey())) {
                    paginator.addLine("<m>" + String.valueOf(constant.getKey().charAt(0)).toUpperCase() + constant.getKey().substring(1) + "<r>  <m>" + constant.getValue());
                    continue;
                }
                paginator.addLine("<a>" + String.valueOf(constant.getKey().charAt(0)).toUpperCase() + constant.getKey().substring(1) + "<b>  " + constant.getValue());
            }
            paginator.addLine("");
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }
}

